# Logical Fallacies in Scientific Discourse

## Fallacies of Causation

### 1. Post Hoc Ergo Propter Hoc (After This, Therefore Because of This)
**Description:** Assuming that because B happened after A, A caused B.

**Examples:**
- "I took this supplement and my cold went away, so the supplement cured my cold."
- "Autism diagnoses increased after vaccine schedules changed, so vaccines cause autism."
- "I wore my lucky socks and won the game, so the socks caused the win."

**Why fallacious:** Temporal sequence is necessary but not sufficient for causation. Correlation ≠ causation.

**Related:** *Cum hoc ergo propter hoc* (with this, therefore because of this) - correlation mistaken for causation even without temporal order.

### 2. Confusing Correlation with Causation
**Description:** Assuming correlation implies direct causal relationship.

**Examples:**
- "Countries that eat more chocolate have more Nobel Prize winners, so chocolate makes you smarter."
- "Ice cream sales correlate with drowning deaths, so ice cream causes drowning."

**Reality:** Often due to confounding variables (hot weather causes both ice cream sales and swimming).

### 3. Reverse Causation
**Description:** Confusing cause and effect direction.

**Examples:**
- "Depression is associated with inflammation, so inflammation causes depression." (Could be: depression causes inflammation)
- "Wealthy people are healthier, so wealth causes health." (Could be: health enables wealth accumulation)

**Solution:** Longitudinal studies and experimental designs to establish temporal order.

### 4. Single Cause Fallacy
**Description:** Attributing complex phenomena to one cause when multiple factors contribute.

**Examples:**
- "Crime is caused by poverty." (Ignores many other contributing factors)
- "Heart disease is caused by fat intake." (Oversimplifies multifactorial disease)

**Reality:** Most outcomes have multiple contributing causes.

## Fallacies of Generalization

### 5. Hasty Generalization
**Description:** Drawing broad conclusions from insufficient evidence.

**Examples:**
- "My uncle smoked and lived to 90, so smoking isn't dangerous."
- "This drug worked in 5 patients, so it's effective for everyone."
- "I saw three black swans, so all swans are black."

**Why fallacious:** Small, unrepresentative samples don't support universal claims.

### 6. Anecdotal Fallacy
**Description:** Using personal experience or isolated examples as proof.

**Examples:**
- "I know someone who survived cancer using alternative medicine, so it works."
- "My grandmother never exercised and lived to 100, so exercise is unnecessary."

**Why fallacious:** Anecdotes are unreliable due to selection bias, memory bias, and confounding. Plural of anecdote ≠ data.

### 7. Cherry Picking (Suppressing Evidence)
**Description:** Selecting only evidence that supports your position while ignoring contradictory evidence.

**Examples:**
- Citing only studies showing supplement benefits while ignoring null findings
- Highlighting successful predictions while ignoring failed ones
- Showing graphs that start at convenient points

**Detection:** Look for systematic reviews, not individual studies.

### 8. Ecological Fallacy
**Description:** Inferring individual characteristics from group statistics.

**Example:**
- "Average income in this neighborhood is high, so this person must be wealthy."
- "This country has low disease rates, so any individual from there is unlikely to have disease."

**Why fallacious:** Group-level patterns don't necessarily apply to individuals.

## Fallacies of Authority and Tradition

### 9. Appeal to Authority (Argumentum ad Verecundiam)
**Description:** Accepting claims because an authority figure said them, without evidence.

**Examples:**
- "Dr. X says this treatment works, so it must." (If Dr. X provides no data)
- "Einstein believed in God, so God exists." (Einstein's physics expertise doesn't transfer)
- "99% of doctors recommend..." (Appeal to majority + authority without evidence)

**Valid use of authority:** Experts providing evidence-based consensus in their domain.

**Invalid:** Authority opinions without evidence, or outside their expertise.

### 10. Appeal to Antiquity/Tradition
**Description:** Assuming something is true or good because it's old or traditional.

**Examples:**
- "Traditional medicine has been used for thousands of years, so it must work."
- "This theory has been accepted for decades, so it must be correct."

**Why fallacious:** Age doesn't determine validity. Many old beliefs have been disproven.

### 11. Appeal to Novelty
**Description:** Assuming something is better because it's new.

**Examples:**
- "This is the latest treatment, so it must be superior."
- "New research overturns everything we knew." (Often overstated)

**Why fallacious:** New ≠ better. Established treatments often outperform novel ones.

## Fallacies of Relevance

### 12. Ad Hominem (Attack the Person)
**Description:** Attacking the person making the argument rather than the argument itself.

**Types:**
- **Abusive:** "He's an idiot, so his theory is wrong."
- **Circumstantial:** "She's funded by industry, so her findings are false."
- **Tu Quoque:** "You smoke, so your anti-smoking argument is invalid."

**Why fallacious:** Personal characteristics don't determine argument validity.

**Note:** Conflicts of interest are worth noting but don't invalidate evidence.

### 13. Genetic Fallacy
**Description:** Judging something based on its origin rather than its merits.

**Examples:**
- "This idea came from a drug company, so it's wrong."
- "Ancient Greeks believed this, so it's outdated."

**Better approach:** Evaluate evidence regardless of source.

### 14. Appeal to Emotion
**Description:** Manipulating emotions instead of presenting evidence.

**Types:**
- **Appeal to fear:** "If you don't vaccinate, your child will die."
- **Appeal to pity:** "Think of the suffering patients who need this unproven treatment."
- **Appeal to flattery:** "Smart people like you know that..."

**Why fallacious:** Emotional reactions don't determine truth.

### 15. Appeal to Consequences (Argumentum ad Consequentiam)
**Description:** Arguing something is true/false based on whether consequences are desirable.

**Examples:**
- "Climate change can't be real because the solutions would hurt the economy."
- "Free will must exist because without it, morality is impossible."

**Why fallacious:** Reality is independent of what we wish were true.

### 16. Appeal to Nature (Naturalistic Fallacy)
**Description:** Assuming "natural" means good, safe, or effective.

**Examples:**
- "This treatment is natural, so it's safe."
- "Organic food is natural, so it's healthier."
- "Vaccines are unnatural, so they're harmful."

**Why fallacious:**
- Many natural things are deadly (arsenic, snake venom, hurricanes)
- Many synthetic things are beneficial (antibiotics, vaccines)
- "Natural" is often poorly defined

### 17. Moralistic Fallacy
**Description:** Assuming what ought to be true is true.

**Examples:**
- "There shouldn't be sex differences in ability, so they don't exist."
- "People should be rational, so they are."

**Why fallacious:** Desires about reality don't change reality.

## Fallacies of Structure

### 18. False Dichotomy (False Dilemma)
**Description:** Presenting only two options when more exist.

**Examples:**
- "Either you're with us or against us."
- "It's either genetic or environmental." (Usually both)
- "Either the treatment works or it doesn't." (Ignores partial effects)

**Reality:** Most issues have multiple options and shades of gray.

### 19. Begging the Question (Circular Reasoning)
**Description:** Assuming what you're trying to prove.

**Examples:**
- "This medicine works because it has healing properties." (What are healing properties? That it works!)
- "God exists because the Bible says so, and the Bible is true because it's God's word."

**Detection:** Check if the conclusion is hidden in the premises.

### 20. Moving the Goalposts
**Description:** Changing standards of evidence after initial standards are met.

**Example:**
- Skeptic: "Show me one study."
- [Shows study]
- Skeptic: "That's just one study; show me a meta-analysis."
- [Shows meta-analysis]
- Skeptic: "But meta-analyses have limitations..."

**Why problematic:** No amount of evidence will ever be sufficient.

### 21. Slippery Slope
**Description:** Arguing that one step will inevitably lead to extreme outcomes without justification.

**Example:**
- "If we allow gene editing for disease, we'll end up with designer babies and eugenics."

**When valid:** If intermediate steps are actually likely.

**When fallacious:** If chain of events is speculative without evidence.

### 22. Straw Man
**Description:** Misrepresenting an argument to make it easier to attack.

**Example:**
- Position: "We should teach evolution in schools."
- Straw man: "So you think we should tell kids they're just monkeys?"

**Detection:** Ask: Is this really what they're claiming?

## Fallacies of Statistical and Scientific Reasoning

### 23. Texas Sharpshooter Fallacy
**Description:** Cherry-picking data clusters to fit a pattern, like shooting arrows then drawing targets around them.

**Examples:**
- Finding cancer clusters and claiming environmental causes (without accounting for random clustering)
- Data mining until finding significant correlations

**Why fallacious:** Patterns in random data are inevitable; finding them doesn't prove causation.

### 24. Base Rate Fallacy
**Description:** Ignoring prior probability when evaluating evidence.

**Example:**
- Disease affects 0.1% of population; test is 99% accurate
- Positive test ≠ 99% probability of disease
- Actually ~9% probability (due to false positives exceeding true positives)

**Solution:** Use Bayesian reasoning; consider base rates.

### 25. Prosecutor's Fallacy
**Description:** Confusing P(Evidence|Innocent) with P(Innocent|Evidence).

**Example:**
- "The probability of this DNA match occurring by chance is 1 in 1 million, so there's only a 1 in 1 million chance the defendant is innocent."

**Why fallacious:** Ignores base rates and prior probability.

### 26. McNamara Fallacy (Quantitative Fallacy)
**Description:** Focusing only on what can be easily measured while ignoring important unmeasured factors.

**Example:**
- Judging school quality only by test scores (ignoring creativity, social skills, ethics)
- Measuring healthcare only by quantifiable outcomes (ignoring quality of life)

**Quote:** "Not everything that counts can be counted, and not everything that can be counted counts."

### 27. Multiple Comparisons Fallacy
**Description:** Not accounting for increased false positive rate when testing many hypotheses.

**Example:**
- Testing 20 hypotheses at p < .05 gives ~65% chance of at least one false positive
- Claiming jellybean color X causes acne after testing 20 colors

**Solution:** Correct for multiple comparisons (Bonferroni, FDR).

### 28. Reification (Hypostatization)
**Description:** Treating abstract concepts as if they were concrete things.

**Examples:**
- "Evolution wants organisms to survive." (Evolution doesn't "want")
- "The gene for intelligence" (Intelligence isn't one gene)
- "Nature selects..." (Nature doesn't consciously select)

**Why problematic:** Can lead to confused thinking about mechanisms.

## Fallacies of Scope and Definition

### 29. No True Scotsman
**Description:** Retroactively excluding counterexamples by redefining criteria.

**Example:**
- "No natural remedy has side effects."
- "But poison ivy is natural and causes reactions."
- "Well, no *true* natural remedy has side effects."

**Why fallacious:** Moves goalposts to protect claim from falsification.

### 30. Equivocation
**Description:** Using a word with multiple meanings inconsistently.

**Example:**
- "Evolution is just a theory. Theories are guesses. So evolution is just a guess."
- (Conflates colloquial "theory" with scientific "theory")

**Detection:** Check if key terms are used consistently.

### 31. Ambiguity
**Description:** Using vague language that can be interpreted multiple ways.

**Example:**
- "Quantum healing" (What does "quantum" mean here?)
- "Natural" (Animals? Not synthetic? Organic? Common?)

**Why problematic:** Claims become unfalsifiable when terms are undefined.

### 32. Mind Projection Fallacy
**Description:** Projecting mental constructs onto reality.

**Example:**
- Assuming categories that exist in language exist in nature
- "Which chromosome is the gene for X on?" when X is polygenic and partially environmental

**Better:** Recognize human categories may not carve nature at the joints.

## Fallacies Specific to Science

### 33. Galileo Gambit
**Description:** "They laughed at Galileo, and he was right, so if they're laughing at me, I must be right too."

**Why fallacious:**
- They laughed at Galileo, and he was right
- They also laughed at countless crackpots who were wrong
- Being an outsider doesn't make you right

**Reality:** Revolutionary ideas are usually well-supported by evidence.

### 34. Argument from Ignorance (Ad Ignorantiam)
**Description:** Assuming something is true because it hasn't been proven false (or vice versa).

**Examples:**
- "No one has proven homeopathy doesn't work, so it works."
- "We haven't found evidence of harm, so it must be safe."

**Why fallacious:** Absence of evidence ≠ evidence of absence (though it can be, depending on how hard we've looked).

**Burden of proof:** Falls on the claimant, not the skeptic.

### 35. God of the Gaps
**Description:** Explaining gaps in knowledge by invoking supernatural or unfalsifiable causes.

**Examples:**
- "We don't fully understand consciousness, so it must be spiritual."
- "This complexity couldn't arise naturally, so it must be designed."

**Why problematic:**
- Fills gaps with non-explanations
- Discourages genuine investigation
- History shows gaps get filled by natural explanations

### 36. Nirvana Fallacy (Perfect Solution Fallacy)
**Description:** Rejecting solutions because they're imperfect.

**Examples:**
- "Vaccines aren't 100% effective, so they're worthless."
- "This diet doesn't work for everyone, so it doesn't work."

**Reality:** Most interventions are partial; perfection is rare.

**Better:** Compare to alternatives, not to perfection.

### 37. Special Pleading
**Description:** Applying standards to others but not to oneself.

**Examples:**
- "My anecdotes count as evidence, but yours don't."
- "Mainstream medicine needs RCTs, but my alternative doesn't."
- "Correlation doesn't imply causation—except when it supports my view."

**Why fallacious:** Evidence standards should apply consistently.

### 38. Unfalsifiability
**Description:** Formulating claims in ways that cannot be tested or disproven.

**Examples:**
- "This energy can't be detected by any instrument."
- "It works, but only if you truly believe."
- "Failures prove the conspiracy is even deeper."

**Why problematic:** Unfalsifiable claims aren't scientific; they can't be tested.

**Good science:** Makes specific, testable predictions.

### 39. Affirming the Consequent
**Description:** If A, then B. B is true. Therefore, A is true.

**Example:**
- "If the drug works, symptoms improve. Symptoms improved. Therefore, the drug worked."
- (Could be placebo, natural history, regression to mean)

**Why fallacious:** Other causes could produce the same outcome.

**Valid form:** Modus ponens: If A, then B. A is true. Therefore, B is true.

### 40. Denying the Antecedent
**Description:** If A, then B. A is false. Therefore, B is false.

**Example:**
- "If you have fever, you have infection. You don't have fever. Therefore, you don't have infection."

**Why fallacious:** B can be true even when A is false.

## Avoiding Logical Fallacies

### Practical Steps

1. **Identify the claim** - What exactly is being argued?

2. **Identify the evidence** - What supports the claim?

3. **Check the logic** - Does the evidence actually support the claim?

4. **Look for hidden assumptions** - What unstated beliefs does the argument rely on?

5. **Consider alternatives** - What other explanations fit the evidence?

6. **Check for emotional manipulation** - Is the argument relying on feelings rather than facts?

7. **Evaluate the source** - Are there conflicts of interest? Is this within their expertise?

8. **Look for balance** - Are counterarguments addressed fairly?

9. **Assess the evidence** - Is it anecdotal, observational, or experimental? How strong?

10. **Be charitable** - Interpret arguments in their strongest form (steel man, not straw man).

### Questions to Ask

- Is the conclusion supported by the premises?
- Are there unstated assumptions?
- Is the evidence relevant to the conclusion?
- Are counterarguments acknowledged?
- Could alternative explanations account for the evidence?
- Is the reasoning consistent?
- Are terms defined clearly?
- Is evidence being cherry-picked?
- Are emotions being manipulated?
- Would this reasoning apply consistently to other cases?

### Common Patterns

**Good Arguments:**
- Clearly defined terms
- Relevant, sufficient evidence
- Valid logical structure
- Acknowledges limitations and alternatives
- Proportional conclusions
- Transparent about uncertainty
- Applies consistent standards

**Poor Arguments:**
- Vague or shifting definitions
- Irrelevant or insufficient evidence
- Logical leaps
- Ignores counterevidence
- Overclaimed conclusions
- False certainty
- Double standards

## Remember

- **Fallacious reasoning doesn't mean the conclusion is false** - just that this argument doesn't support it.
- **Identifying fallacies isn't about winning** - it's about better understanding reality.
- **We all commit fallacies** - recognizing them in ourselves is as important as in others.
- **Charity principle** - Interpret arguments generously; don't assume bad faith.
- **Focus on claims, not people** - Ad hominem goes both ways.
