# Slide Design Principles for Scientific Presentations

## Overview

Effective slide design enhances comprehension, maintains audience attention, and ensures your scientific message is communicated clearly. This guide covers visual hierarchy, typography, color theory, layout principles, and accessibility considerations for creating professional scientific presentations.

## Core Design Principles

### 1. Simplicity and Clarity

**The Fundamental Rule**: Each slide should communicate ONE main idea.

**Why It Matters**:
- Audiences can only process limited information at once
- Complexity causes cognitive overload
- Simple slides are remembered; busy slides are forgotten

**Application**:
- ✅ One message per slide
- ✅ Minimal text (audiences read OR listen, not both simultaneously)
- ✅ Clear visual focus
- ✅ Generous white space
- ❌ Avoid cramming multiple concepts onto one slide

**Example Comparison**:
```
BAD: Single slide with:
- 3 different graphs
- 8 bullet points
- 2 tables
- Dense caption text

GOOD: Three separate slides:
- Slide 1: First graph with 2-3 key points
- Slide 2: Second graph with interpretation
- Slide 3: Summary table with highlighted finding
```

### 2. Visual Hierarchy

Guide attention to the most important elements through size, color, and position.

**Hierarchy Levels**:
1. **Primary**: Main message or key data (largest, highest contrast)
2. **Secondary**: Supporting information (medium size)
3. **Tertiary**: Details and labels (smaller, lower contrast)

**Techniques**:

**Size**:
- Title: Largest (36-54pt)
- Key findings: Large (24-32pt)
- Supporting text: Medium (18-24pt)
- Labels and notes: Smallest but legible (14-18pt)

**Color**:
- High contrast for key elements
- Accent colors for emphasis
- Muted colors for background or secondary info

**Position**:
- Top-left or top-center: Primary content (Western reading pattern)
- Center: Focal point for key visuals
- Bottom or sides: Supporting details

**Weight**:
- Bold for emphasis on key terms
- Regular weight for body text
- Light weight for de-emphasized content

### 3. Consistency

Maintain visual consistency throughout the presentation.

**Elements to Keep Consistent**:
- **Fonts**: Same font family for all slides
- **Colors**: Defined color palette (3-5 colors)
- **Layouts**: Similar slides use same structure
- **Spacing**: Margins and padding uniform
- **Style**: Figure formats, bullet styles, numbering

**Benefits**:
- Professional appearance
- Reduced cognitive load (audiences learn your visual language)
- Focus on content, not adjusting to new formats
- Easy to identify information types

**Template Approach**:
- Create master slide with standard elements
- Design 3-5 layout variants (title, content, figure, section divider)
- Apply consistently throughout

## Typography

### Font Selection

**Recommended Font Types**:

**Sans-Serif Fonts** (Highly Recommended):
- **Arial**: Universal, highly legible
- **Helvetica**: Clean, professional
- **Calibri**: Modern default, works well
- **Gill Sans**: Elegant sans-serif
- **Futura**: Geometric, modern
- **Avenir**: Friendly, professional

**Serif Fonts** (Use Sparingly):
- Generally harder to read on screens
- Acceptable for titles in some contexts
- Avoid for body text in presentations

**Avoid**:
- ❌ Script or handwriting fonts (illegible from distance)
- ❌ Decorative fonts (distracting)
- ❌ Condensed fonts (hard to read)
- ❌ Multiple font families (>2 looks unprofessional)

### Font Sizes

**Minimum Readable Sizes**:
- **Title slide title**: 44-54pt
- **Section headers**: 36-44pt
- **Slide titles**: 32-40pt
- **Body text**: 24-28pt (absolute minimum 18pt)
- **Figure labels**: 18-24pt
- **Captions and citations**: 14-16pt (use sparingly)

**The Room Test**:
- Can text be read from the back of the room?
- Rule: Body text should be readable at 6× screen height distance
- When in doubt: go larger

**Size Relationships**:
```
Title: 40pt
━━━━━━━━━━━━━━━━━
Subheading: 28pt
─────────────
Body text: 24pt
Regular content for audience

Caption: 16pt
```

### Text Formatting

**Best Practices**:

**Line Length**:
- Maximum 50-60 characters per line
- Break long sentences into multiple lines
- Use phrases, not full sentences when possible

**Line Spacing**:
- 1.2-1.5× line height for readability
- More spacing for dense content
- Consistent spacing throughout

**Alignment**:
- **Left-aligned**: Best for body text (natural reading)
- **Center-aligned**: Titles, short phrases, key messages
- **Right-aligned**: Rarely used (occasionally for design balance)
- **Justified**: Avoid (creates awkward spacing)

**Emphasis**:
- ✅ **Bold** for key terms (use sparingly)
- ✅ Color for emphasis (consistent meaning)
- ✅ Size increase for importance
- ❌ Avoid italics (hard to read from distance)
- ❌ Avoid underline (confused with hyperlinks)
- ❌ AVOID ALL CAPS FOR BODY TEXT (READS AS SHOUTING)

### The 6×6 Rule

**Guideline**: Maximum 6 bullets per slide, maximum 6 words per bullet.

**Rationale**:
- More text = audience reads instead of listens
- Bullet points are prompts, not sentences
- You provide the explanation verbally

**Better Approach**:
- 3-4 bullets optimal
- 4-8 words per bullet
- Use fragments, not complete sentences
- Consider replacing text with visuals

**Example Transformation**:
```
TOO MUCH TEXT:
• Our study examined the relationship between dietary interventions 
  and cardiovascular outcomes in 1,500 participants over 5 years
• We found that participants in the intervention group showed 
  significantly reduced risk compared to controls
• The effect size was larger than previous studies and persisted 
  at long-term follow-up

BETTER:
• 5-year dietary intervention study
• 27% reduced cardiovascular risk
• Largest effect to date
```

## Color Theory

### Color Palettes for Scientific Presentations

**Purpose-Driven Color Selection**:

**Professional/Academic** (Conservative):
- Navy blue (#1C3D5A), gray (#4A5568), white (#FFFFFF)
- Accent: Orange (#E67E22) or green (#27AE60)
- Use: Faculty seminars, grant presentations, institutional talks

**Modern/Engaging** (Energetic):
- Teal (#0A9396), coral (#EE6C4D), cream (#F4F1DE)
- Accent: Burgundy (#780000)
- Use: Conference talks, public engagement, TED-style talks

**High Contrast** (Maximum Legibility):
- Black text (#000000) on white (#FFFFFF)
- Dark blue (#003366) on white
- White on dark gray (#2D3748)
- Use: Large venues, virtual presentations, accessibility priority

**Data Visualization** (Color-blind Safe):
- Blue (#0173B2), orange (#DE8F05), green (#029E73), red (#CC78BC)
- Based on Wong/IBM palettes
- Use: Figures with categorical data, bar charts, line plots

### Color Psychology in Science

**Blue**:
- Associations: Trust, stability, professionalism, intelligence
- Use: Backgrounds, institutional presentations, technology topics
- Caution: Can feel cold; balance with warmer accents

**Green**:
- Associations: Growth, health, nature, sustainability
- Use: Biology, environmental science, health outcomes
- Caution: Avoid red-green combinations (color blindness)

**Red/Orange**:
- Associations: Energy, urgency, warning, importance
- Use: Highlighting critical findings, emphasis, calls to action
- Caution: Don't overuse; loses impact

**Purple**:
- Associations: Innovation, creativity, wisdom
- Use: Neuroscience, novel methods, creative research
- Caution: Can appear less serious in some contexts

**Gray**:
- Associations: Neutrality, professionalism, sophistication
- Use: Backgrounds, de-emphasized content, grounding
- Caution: Can feel dull if overused

### Color Contrast and Accessibility

**WCAG Standards** (Web Content Accessibility Guidelines):
- **Level AA**: 4.5:1 contrast ratio for normal text
- **Level AAA**: 7:1 contrast ratio (preferred for presentations)

**High Contrast Combinations**:
- ✅ Black on white (21:1)
- ✅ Dark blue (#003366) on white (12.6:1)
- ✅ White on dark gray (#2D3748) (11.8:1)
- ✅ Dark text (#333333) on cream (#F4F1DE) (9.7:1)

**Low Contrast Combinations** (Avoid):
- ❌ Light gray on white
- ❌ Yellow on white
- ❌ Pastel colors on white backgrounds
- ❌ Red on black (difficult to read)

**Testing Contrast**:
- Use online tools (e.g., WebAIM Contrast Checker)
- Print slide in grayscale (should remain legible)
- View from distance (simulate audience perspective)

### Color Blindness Considerations

**Prevalence**: ~8% of men, ~0.5% of women have color vision deficiency

**Most Common**: Red-green color blindness (protanopia/deuteranopia)

**Safe Practices**:
- ✅ Use blue/orange instead of red/green
- ✅ Add patterns or shapes in addition to color
- ✅ Use color AND other differentiators (shape, size, position)
- ✅ Test with color blindness simulator

**Color-Blind Safe Palettes**:
```
Primary: Blue (#0173B2)
Contrast: Orange (#DE8F05)  [NOT green]
Additional: Magenta (#CC78BC), Teal (#029E73)
```

**Figure Design**:
- Don't rely solely on red vs. green lines
- Use different line styles (solid, dashed, dotted)
- Use symbols (circle, square, triangle) for scatter plots
- Label directly on plot rather than color legend only

## Layout and Composition

### The Rule of Thirds

Divide slide into 3×3 grid; place key elements at intersections or along lines.

**Application**:
```
+-------+-------+-------+
|   ┃   |   ┃   |   ┃   |
|---●---|---●---|---●---|  ← Key focal points (●)
|   ┃   |   ┃   |   ┃   |
|---●---|---●---|---●---|
|   ┃   |   ┃   |   ┃   |
|---●---|---●---|---●---|
|   ┃   |   ┃   |   ┃   |
+-------+-------+-------+
```

**Benefits**:
- More visually interesting than centered layouts
- Natural eye flow
- Professional appearance
- Guides attention strategically

**Example Usage**:
- Place key figure at right third
- Text summary on left two-thirds
- Title at top third line
- Logo at bottom-right intersection

### White Space

**Definition**: Empty space around and between elements.

**Purpose**:
- Gives content room to "breathe"
- Increases focus on important elements
- Prevents overwhelming the audience
- Projects professionalism and confidence

**Guidelines**:
- Margins: Minimum 5-10% of slide on all sides
- Element spacing: Clear separation between unrelated items
- Text padding: Space around text blocks
- Don't fill every pixel: Empty space is valuable

**Common Mistakes**:
- Cramming too much on one slide
- Extending content to edges
- No space between elements
- Fear of "wasting" space

### Layout Patterns

**Title + Content**:
```
┌─────────────────────────┐
│ Slide Title             │
├─────────────────────────┤
│                         │
│    Content Area         │
│    (text, figure,       │
│     or combination)     │
│                         │
└─────────────────────────┘
```
Use: Standard slide type, most common

**Two Column**:
```
┌─────────────────────────┐
│ Slide Title             │
├───────────┬─────────────┤
│           │             │
│  Text     │   Figure    │
│  Column   │   Column    │
│           │             │
└───────────┴─────────────┘
```
Use: Comparing items, text + figure

**Full-Slide Figure**:
```
┌─────────────────────────┐
│                         │
│                         │
│    Large Figure or      │
│    Image                │
│                         │
│                         │
└─────────────────────────┘
```
Use: Key results, impactful visuals

**Text Overlay**:
```
┌─────────────────────────┐
│   ┌─────────────┐       │
│   │ Text Box    │       │
│   └─────────────┘       │
│     Background Image    │
│                         │
└─────────────────────────┘
```
Use: Title slide, section dividers

**Grid Layout**:
```
┌─────────────────────────┐
│ Title                   │
├─────────┬───────┬───────┤
│ Item 1  │ Item 2│ Item 3│
├─────────┼───────┼───────┤
│ Item 4  │ Item 5│ Item 6│
└─────────┴───────┴───────┘
```
Use: Multiple related items, comparisons

### Alignment

**Principle**: Align elements to create visual order and relationships.

**Types**:

**Edge Alignment**:
- Align left edges of text blocks
- Align right edges of figures
- Align top edges of items in row

**Center Alignment**:
- Center title on slide
- Center key messages
- Center lone figures

**Grid Alignment**:
- Use invisible grid
- Snap elements to grid lines
- Maintains consistency across slides

**Visual Impact**:
- Aligned elements look intentional and professional
- Misaligned elements appear careless
- Small misalignments are very noticeable

## Background Design

### Background Colors

**Best Practices**:

**Light Backgrounds** (Most Common):
- White or off-white (#FFFFFF, #F8F9FA)
- Very light gray (#F5F5F5)
- Cream/beige (#FAF8F3)

**Advantages**:
- Maximum contrast for dark text
- Works in any lighting
- Professional and clean
- Easier on projectors

**Dark Backgrounds**:
- Dark gray (#2D3748)
- Navy blue (#1A202C)
- Black (#000000)

**Advantages**:
- Modern, sophisticated
- Good for dark venues
- Reduces eye strain in dark rooms
- Makes colors pop

**Disadvantages**:
- Requires light-colored text
- Can be difficult in bright rooms
- Some projectors handle poorly

**Gradient Backgrounds**:
- ✅ Subtle gradients acceptable (light to lighter)
- ❌ Avoid busy or high-contrast gradients
- ❌ Don't distract from content

**Image Backgrounds**:
- Use only for title/section slides
- Ensure sufficient contrast with text
- Add semi-transparent overlay if needed
- Avoid busy or cluttered images

### Borders and Frames

**Minimal Approach** (Recommended):
- No borders on most slides
- Let white space define boundaries
- Clean, modern appearance

**Selective Borders**:
- Around key figures for emphasis
- Separating distinct sections
- Highlighting callout boxes
- Simple, thin lines only

**Avoid**:
- Decorative borders
- Thick, colorful frames
- Clipart-style elements
- 3D effects and shadows

## Visual Elements

### Icons and Graphics

**Purpose**:
- Visual anchors for concepts
- Break up text-heavy slides
- Quick recognition of section types
- Add visual interest

**Best Practices**:
- ✅ Consistent style (all outline or all filled)
- ✅ Simple, recognizable designs
- ✅ Appropriate size (not too large or small)
- ✅ Limited color palette matching theme
- ❌ Avoid clipart or cartoonish graphics (unless appropriate)
- ❌ Don't use for decoration only (should convey meaning)

**Sources**:
- Font Awesome
- Noun Project
- Material Design Icons
- Custom scientific illustrations

### Bullets and Lists

**Bullet Styles**:
- **Simple shapes**: Circle (•), square (■), dash (−)
- **Avoid**: Complex symbols, changing bullet styles within list
- **Hierarchy**: Different bullets for different levels

**List Best Practices**:
- Maximum 4-6 items per list
- Parallel structure (all start with verb, or all nouns, etc.)
- Use fragments, not complete sentences
- Adequate spacing between items (1.5-2× line height)

**Alternative to Bullets**:
- **Numbered lists**: When order matters
- **Icons**: Visual representation of each point
- **Progressive builds**: Reveal one point at a time
- **Separate slides**: One concept per slide

### Shapes and Dividers

**Uses**:
- Background rectangles to highlight content
- Arrows showing relationships or flow
- Circles for emphasis or grouping
- Lines separating sections

**Guidelines**:
- Keep shapes simple (rectangles, circles, lines)
- Use brand colors
- Maintain consistency
- Avoid 3D effects
- Don't overuse

## Animation and Builds

### When to Use Animation

**Appropriate Uses**:
- **Progressive disclosure**: Reveal bullet points one at a time
- **Build complex figures**: Add layers incrementally
- **Show process**: Illustrate sequential steps
- **Emphasize transitions**: Highlight connections
- **Control pacing**: Prevent audience from reading ahead

**Inappropriate Uses**:
- ❌ Decoration or entertainment
- ❌ Every slide transition
- ❌ Multiple animations per slide
- ❌ Distracting effects (spin, bounce, etc.)

### Types of Animations

**Entrance**:
- **Appear**: Instant (good for fast-paced talks)
- **Fade**: Subtle, professional
- **Wipe**: Directional reveal
- Avoid: Fly in, bounce, spiral, etc.

**Exit**:
- Rarely needed
- Use to remove intermediary steps
- Keep simple (fade or disappear)

**Emphasis**:
- Color change for highlighting
- Bold/underline to draw attention
- Grow slightly for importance
- Use very sparingly

**Builds**:
- Reveal bullet points progressively
- Add elements to complex figure
- Show before/after states
- Demonstrate process steps

**Best Practices**:
- Fast transitions (0.2-0.3 seconds)
- Consistent animation type throughout
- Click to advance (not automatic timing)
- Builds should add clarity, not complexity

## Common Design Mistakes

### Content Mistakes

**Too Much Text**:
- Problem: Audience reads instead of listening
- Fix: Use key phrases, not paragraphs; move details to notes

**Too Many Concepts per Slide**:
- Problem: Cognitive overload, unclear focus
- Fix: One idea per slide; split complex slides into multiple

**Inconsistent Formatting**:
- Problem: Looks unprofessional, distracting
- Fix: Use templates, maintain style guide

**Poor Contrast**:
- Problem: Illegible from distance
- Fix: Test at actual presentation size, use high-contrast combinations

**Tiny Fonts**:
- Problem: Unreadable for audience
- Fix: Minimum 18pt, preferably 24pt+ for body text

### Visual Mistakes

**Cluttered Slides**:
- Problem: No clear focal point, overwhelming
- Fix: Embrace white space, remove non-essential elements

**Low-Quality Images**:
- Problem: Pixelated or blurry figures
- Fix: Use high-resolution images (300 DPI minimum)

**Distracting Backgrounds**:
- Problem: Competes with content
- Fix: Simple, solid colors or subtle gradients

**Overuse of Effects**:
- Problem: Looks amateurish, distracting
- Fix: Minimal or no shadows, gradients, 3D effects

**Misaligned Elements**:
- Problem: Appears careless
- Fix: Use alignment tools, grids, and guides

### Color Mistakes

**Insufficient Contrast**:
- Problem: Hard to read
- Fix: Test with contrast checker, use dark on light or light on dark

**Too Many Colors**:
- Problem: Chaotic, unprofessional
- Fix: Limit to 3-5 colors total

**Red-Green Combinations**:
- Problem: Invisible to color-blind audience members
- Fix: Use blue-orange or add patterns/shapes

**Clashing Colors**:
- Problem: Visually jarring
- Fix: Use color palette tools, test combinations

## Accessibility

### Designing for All Audiences

**Visual Impairments**:
- High contrast text (minimum 4.5:1, preferably 7:1)
- Large fonts (minimum 18pt, prefer 24pt+)
- Simple, clear fonts
- No reliance on color alone to convey meaning

**Color Blindness**:
- Avoid red-green combinations
- Use patterns, shapes, or labels in addition to color
- Test with color blindness simulator
- Provide alternative visual cues

**Cognitive Considerations**:
- Simple, uncluttered layouts
- One concept per slide
- Clear visual hierarchy
- Consistent navigation and structure

**Presentation Environment**:
- Works in various lighting conditions
- Visible from distance (back of large room)
- Readable on different screens (laptop, projector, phone)
- Printable in grayscale if needed

### Alternative Text and Descriptions

**For Figures**:
- Provide verbal description during talk
- Include detailed caption in notes
- Describe key patterns: "Notice the increasing trend..."

**For Complex Visuals**:
- Break into components
- Use progressive builds
- Provide interpretive context

## Design Workflow

### Step 1: Define Visual Identity

Before creating slides:
1. **Color palette**: Choose 3-5 colors
2. **Fonts**: Select 1-2 font families
3. **Style**: Decide on overall aesthetic (minimal, bold, traditional)
4. **Templates**: Create master slides for different types

### Step 2: Create Master Templates

Design 4-6 slide layouts:
1. **Title slide**: Name, title, affiliation
2. **Section divider**: Major transitions
3. **Content slide**: Standard text/bullets
4. **Figure slide**: Large visual focus
5. **Two-column**: Text + figure side-by-side
6. **Closing**: Questions, contact, acknowledgments

### Step 3: Apply Consistently

For each slide:
- Choose appropriate template
- Add content (text or visuals)
- Ensure alignment and spacing
- Check font sizes and contrast
- Verify consistency with other slides

### Step 4: Review and Refine

Review checklist:
- [ ] Every slide has clear focus
- [ ] Text is minimal and readable
- [ ] Visual hierarchy is clear
- [ ] Colors are consistent and accessible
- [ ] Alignment is precise
- [ ] White space is adequate
- [ ] Animations are purposeful
- [ ] Overall flow is smooth

## Tools and Resources

### Design Software

**PowerPoint**:
- Master slides for templates
- Alignment guides and gridlines
- Design Ideas feature for inspiration
- Morph transition for smooth animations

**Keynote** (Mac):
- Beautiful default templates
- Smooth animations
- Magic Move for object transitions

**Google Slides**:
- Collaborative editing
- Cloud-based access
- Simple, clean interface

**LaTeX Beamer**:
- Consistent, professional appearance
- Excellent for equations and code
- Version control friendly
- Reproducible designs

### Design Resources

**Color Tools**:
- Coolors.co: Palette generator
- Adobe Color: Color scheme creator
- WebAIM Contrast Checker: Accessibility testing
- Coblis: Color blindness simulator

**Icon Sources**:
- Font Awesome: General icons
- Noun Project: Specific concepts
- BioIcons: Science-specific graphics
- Flaticon: Large collection

**Inspiration**:
- Scientific presentation examples in your field
- TED talks for delivery style
- Conference websites for design trends
- Design portfolios (Behance, Dribbble)

## Summary Checklist

Before finalizing your slide design:

**Typography**:
- [ ] Font size ≥18pt minimum, preferably 24pt+ for body
- [ ] Maximum 6 bullets per slide, 6 words per bullet
- [ ] Sans-serif fonts used throughout
- [ ] Consistent font family (1-2 max)

**Color**:
- [ ] High contrast text-background (4.5:1 minimum)
- [ ] Limited color palette (3-5 colors)
- [ ] Color-blind safe combinations
- [ ] Consistent color use throughout

**Layout**:
- [ ] One main idea per slide
- [ ] Generous white space (don't fill every pixel)
- [ ] Elements aligned precisely
- [ ] Consistent layouts for similar content

**Visual Elements**:
- [ ] High-resolution images (300 DPI)
- [ ] Consistent icon/graphic style
- [ ] Minimal decorative elements
- [ ] Clear visual hierarchy

**Accessibility**:
- [ ] Readable from back of room
- [ ] Works in various lighting conditions
- [ ] No reliance on color alone
- [ ] Clear without audio (for recorded talks)

**Professional Polish**:
- [ ] Consistent template throughout
- [ ] No typos or formatting errors
- [ ] Smooth animations (if any)
- [ ] Clean, uncluttered appearance
