# Skill Review Audit Report Template

Use this template to document skill audit findings.

---

## Skill Review Report: [SKILL-NAME]

**Date**: YYYY-MM-DD
**Audit Type**: Deep review / Quick check
**Trigger**: [Why review was performed]
**Time Spent**: [Duration]
**Auditor**: Claude (Sonnet 4.5) / Human

---

### Executive Summary

**Status**: ✅ PASS / ⚠️ WARN / ❌ FAIL

**Findings**:
- 🔴 Critical: [N] issues
- 🟡 High: [N] issues
- 🟠 Medium: [N] issues
- 🟢 Low: [N] issues

**Action Required**: [None / Minor fixes / Comprehensive refactor]

**Version Bump**: [None / Patch / Minor / Major]

---

### Detailed Findings

#### Issue #1: [Short Description]

**Severity**: 🔴 CRITICAL / 🟡 HIGH / 🟠 MEDIUM / 🟢 LOW

**Location**: `file.ts:123` or SKILL.md section

**Problem**:
[Clear description of what's wrong]

**Evidence**:
- Official docs: [URL]
- GitHub issue: [URL] (if applicable)
- npm: `npm view package version` output
- Production example: [GitHub repo URL]

**Impact**:
[What happens if not fixed]

**Fix**:
```diff
- old code
+ new code
```

**Breaking Change**: Yes / No

---

[Repeat for each issue]

---

### Remediation Summary

**Files Deleted** ([N]):
- `path/to/file.ts` (reason)

**Files Created** ([N]):
- `path/to/file.ts` (purpose)

**Files Modified** ([N]):
- `path/to/file.ts` (changes)

**Lines Changed**:
- Removed: [N] lines
- Added: [N] lines
- Net: [±N] lines

---

### Version Update

**Version**: [old] → [new]

**Reason**: [Breaking changes / New features / Bug fixes]

**Migration Path**: [If breaking changes, how to upgrade]

**Changelog**:
```markdown
v[new] (YYYY-MM-DD)
[BREAKING if applicable]: [Summary]

Critical:
- [List critical fixes]

High:
- [List high-priority fixes]

Medium:
- [List medium fixes]

Low:
- [List low fixes]

Migration: [How to upgrade if breaking]
```

---

### Post-Fix Verification

**Discovery Test**:
- ✅ / ❌ Skill recognized by Claude
- ✅ / ❌ Metadata loads correctly

**Template Test** (if applicable):
- ✅ / ❌ Templates build successfully
- ✅ / ❌ No TypeScript errors
- ✅ / ❌ Dependencies resolve

**Consistency Check**:
- ✅ / ❌ SKILL.md vs README.md match
- ✅ / ❌ No contradictions in references/
- ✅ / ❌ Bundled Resources list accurate

**Code Quality**:
- ✅ / ❌ No TODO markers
- ✅ / ❌ No broken links
- ✅ / ❌ All imports valid

**Commit**:
- Hash: [git hash]
- Pushed: ✅ / ❌

---

### Lessons Learned

1. [Key takeaway #1]
2. [Key takeaway #2]
3. [Key takeaway #3]

---

### Recommendations

**Immediate**:
- [Action items that must be done now]

**Future**:
- [Improvements for next review cycle]

**Process**:
- [Suggestions for improving review process]

---

### Appendix

**Automation Output** (`./scripts/review-skill.sh`):
```
[Paste relevant script output]
```

**Manual Verification Notes**:
- [Additional observations]
- [Edge cases discovered]
- [Questions for maintainer]

---

**Audit Complete**: YYYY-MM-DD
**Result**: [Summary of final state]
