# TinaCMS Official Documentation Links

**Last Updated**: 2025-10-24

---

## Core Documentation

- **Official Website**: https://tina.io
- **Documentation Home**: https://tina.io/docs
- **Getting Started**: https://tina.io/docs/setup-overview
- **What's New**: https://tina.io/whats-new/tinacms

---

## Setup & Configuration

- **Setup Overview**: https://tina.io/docs/setup-overview
- **Next.js Setup**: https://tina.io/docs/frameworks/next/overview
- **Next.js App Router**: https://tina.io/docs/frameworks/next/app-router
- **Next.js Pages Router**: https://tina.io/docs/frameworks/next/pages-router
- **Astro Setup**: https://tina.io/docs/frameworks/astro
- **Framework-Agnostic**: https://tina.io/docs/frameworks/other

---

## Schema & Content Modeling

- **Schema Overview**: https://tina.io/docs/schema
- **Content Modeling Intro**: https://tina.io/docs/content-model-intro
- **Collections Reference**: https://tina.io/docs/reference/collections
- **Field Types**: https://tina.io/docs/reference/types
- **Templates**: https://tina.io/docs/reference/templates

---

## Visual Editing

- **Contextual Editing**: https://tina.io/docs/contextual-editing/overview
- **React Visual Editing**: https://tina.io/docs/contextual-editing/react
- **Vue Visual Editing**: https://tina.io/docs/contextual-editing/vue

---

## Self-Hosting

- **Self-Hosted Overview**: https://tina.io/docs/self-hosted/overview
- **Existing Site**: https://tina.io/docs/self-hosted/existing-site
- **Querying Data**: https://tina.io/docs/self-hosted/querying-data
- **Next.js Backend**: https://tina.io/docs/reference/self-hosted/tina-backend/nextjs
- **Vercel Functions**: https://tina.io/docs/reference/self-hosted/tina-backend/vercel-functions
- **Netlify Functions**: https://tina.io/docs/reference/self-hosted/tina-backend/netlify-functions

---

## Authentication

- **Auth Overview**: https://tina.io/docs/reference/self-hosted/auth-provider/overview
- **Auth.js Provider**: https://tina.io/docs/reference/self-hosted/auth-provider/authjs
- **TinaCloud Provider**: https://tina.io/docs/reference/self-hosted/auth-provider/tinacloud
- **Custom Auth**: https://tina.io/docs/reference/self-hosted/auth-provider/bring-your-own

---

## Deployment

- **TinaCloud**: https://tina.io/docs/tinacloud/overview
- **Migrating to Self-Hosted**: https://tina.io/docs/self-hosted/migrating-from-tinacloud
- **Next.js + Vercel**: https://tina.io/docs/self-hosted/starters/nextjs-vercel

---

## Errors & Troubleshooting

- **FAQ**: https://tina.io/docs/introduction/faq
- **Error FAQ**: https://tina.io/docs/errors/faq
- **ESbuild Error**: https://tina.io/docs/errors/esbuild-error
- **Common Migration Errors**: https://tina.io/docs/forestry/common-errors
- **Contributing Troubleshooting**: https://tina.io/docs/contributing/troubleshooting

---

## Extending Tina

- **Extending Overview**: https://tina.io/docs/extending-tina/overview
- **Custom Field Components**: https://tina.io/docs/extending-tina/custom-field-components
- **Format & Parse**: https://tina.io/docs/extending-tina/format-and-parse
- **Custom List Rendering**: https://tina.io/docs/extending-tina/customize-list-ui

---

## Media Management

- **Media Overview**: https://tina.io/docs/reference/media/overview
- **Cloudinary**: https://tina.io/docs/reference/media/external/cloudinary
- **S3**: https://tina.io/docs/reference/media/external/s3
- **Custom Media Store**: https://tina.io/docs/reference/media/external/authentication

---

## GraphQL & Querying

- **GraphQL Overview**: https://tina.io/docs/graphql/overview
- **CLI**: https://tina.io/docs/graphql/cli
- **Queries**: https://tina.io/docs/graphql/queries

---

## Migration Guides

- **Forestry.io Migration**: https://tina.io/docs/forestry/migrate
- **Schema Migration**: https://tina.io/docs/tinacloud/schema-migration
- **Content Modeling (Forestry)**: https://tina.io/docs/forestry/content-modelling

---

## Blog & Tutorials

- **Blog Home**: https://tina.io/blog
- **Using TinaCMS with Next.js**: https://tina.io/blog/using-tinacms-with-nextjs
- **React 19 Support**: https://tina.io/blog/react-19-support
- **TinaCMS + Next.js Perfect Match**: https://tina.io/blog/tina-cloud-and-nextjs-the-perfect-match

---

## Community & Support

- **Discord**: https://discord.gg/zumN63Ybpf
- **GitHub**: https://github.com/tinacms/tinacms
- **GitHub Issues**: https://github.com/tinacms/tinacms/issues
- **GitHub Discussions**: https://github.com/tinacms/tinacms/discussions
- **Twitter/X**: https://twitter.com/tina_cms

---

## Starter Templates

- **Tina Astro Starter**: https://github.com/tinacms/tina-astro-starter
- **Tina Next.js Starter (Alpaca)**: https://github.com/tinacms/tina-starter-alpaca
- **Tina Next.js Example**: https://github.com/tinacms/tinacms-next-example

---

## API Reference

- **Config**: https://tina.io/docs/reference/schema
- **Collections**: https://tina.io/docs/reference/collections
- **Field Types**: https://tina.io/docs/reference/types
- **Templates**: https://tina.io/docs/reference/templates
- **UI Config**: https://tina.io/docs/reference/collections#ui

---

**Last Updated**: 2025-10-24
