---
name: startup-wisdom
description: Apply startup execution wisdom to product, strategy, and business decisions. Use for feature prioritization, build-vs-buy decisions, go-to-market planning, pricing, hiring, scope/timeline reality checks, or when evaluating whether an idea has product-market fit potential.
---

# Startup Wisdom

Practical wisdom from building companies—what actually matters versus what feels important.

## When to Use

- Evaluating whether to build a feature
- Prioritizing what to work on next
- Making build-vs-buy decisions
- Reality-checking timelines and scope
- Thinking about go-to-market
- Hiring and team decisions

## Output Contract

For decisions, structure your analysis as:

```markdown
## Decision: [The Question]

### Recommendation
[1-2 sentences: what to do]

### Reasoning
- [Key factor 1]
- [Key factor 2]
- [Key factor 3]

### Risks
- [Risk] → [Mitigation]

### Framework Applied
[Which principle from this skill guided the recommendation]

### What Would Change This
[Conditions that would flip the recommendation]
```

For feature prioritization:

```markdown
## Feature: [Name]

### Verdict
[Build now / Build later / Don't build / Needs validation]

### Prioritization Score
1. Helps learn something critical? [Y/N]
2. Helps retain existing users? [Y/N]
3. Helps acquire new users? [Y/N]
4. Reduces operational burden? [Y/N]

### Reality Check
- Estimated effort: [honest assessment]
- PMF signal: [are users pulling for this?]
- Reversibility: [can we undo/remove if wrong?]
```

## First Principles

### Speed Over Perfection
- Shipping teaches you more than planning
- Your first version will be wrong; optimize for learning velocity
- The market doesn't care about your architecture
- Perfect is the enemy of shipped

### Focus Is Everything
- Do one thing well before adding another
- Every feature you add is a feature you maintain forever
- Say no to good ideas to execute great ones
- Startups die from indigestion, not starvation

### Cash Is Oxygen
- Revenue > fundraising as validation
- Extend runway before you need to
- Every month of runway is optionality
- Frugality compounds; burn rate is a choice

## Product Thinking

### Finding Product-Market Fit
- PMF feels like pull, not push
- If you have to convince users to use it, you don't have it
- Retention > acquisition as a signal
- Talk to churned users; they tell you the truth

### What to Build First
- Solve a hair-on-fire problem for a specific person
- Build for the user who will pay, not the one who will use for free
- Start with the workflow, not the feature
- 10x better on one dimension beats 2x better on five

### Feature Prioritization
Ask in order:
1. Does this help us learn something critical?
2. Does this help us retain existing users?
3. Does this help us acquire new users?
4. Does this reduce our operational burden?

### When to Add Features
- Only after current features are working and retained
- When users are asking for the same thing repeatedly
- When it unlocks a new segment without fragmenting focus
- Never because a competitor has it

## The Build Decision

### Build When
- It's your core differentiation
- No existing solution fits your specific need
- You need deep control for product experience
- The build cost is low relative to ongoing licensing

### Buy/Use Existing When
- It's not your core value proposition
- Proven solutions exist and integrate well
- Your team lacks domain expertise
- Time-to-market matters more than customization

### The Integration Tax
- Every third-party dependency is a liability
- APIs change, companies pivot, pricing increases
- Build abstractions around external services
- Have a migration path, even if you never use it

## Go-to-Market Reality

### Distribution > Product
- The best product often loses to better distribution
- Build distribution into the product (viral loops, network effects)
- Channels get saturated; early movers win
- Your unfair advantage is often not the product

### Pricing
- Charge more than you're comfortable with
- Price on value delivered, not cost to build
- Free users are not customers; they're a liability
- Willingness to pay is the ultimate validation

### Early Customers
- First 10 customers should come from your network
- If you can't sell to people who know you, strangers won't buy
- Design partners > beta users
- Get commitments before building custom features

## Team & Hiring

### Who to Hire First
- Hire for the stage, not the destination
- Early hires: generalists who ship
- Later hires: specialists who scale
- Culture carriers matter more than credentials

### Hiring Signals
- Strong signal: they've built something (anything)
- Strong signal: they ask good questions about the problem
- Weak signal: pedigree, credentials, brand-name employers
- Red flag: more interested in title than impact

### When to Hire
- When the work is clearly outpacing the team
- When a specific skill gap is blocking progress
- When you have 12+ months of runway
- Not because you raised money

### Firing
- Slow to hire, fast to fire (once you know)
- The team always knows before you act
- Keeping poor performers demoralizes high performers
- Kindness is a quick, clear, generous exit

## Fundraising

### When to Raise
- When you have leverage (traction, alternatives)
- When you know exactly what the money unlocks
- Before you need to (6+ months of runway remaining)
- Not because others are raising

### Investor Selection
- The best investors make you better, not just richer
- References from founders who failed with them
- Ask: "How do you help when things go wrong?"
- Optimize for partner, not firm

### What Investors Actually Care About
- Market size (can this be huge?)
- Team (can these people execute?)
- Traction (is this working?)
- Why now (what changed in the world?)

### Term Sheet Reality
- Valuation matters less than you think
- Control matters more than you think
- Pro-rata rights, board seats, and protective provisions
- Your lawyer should have done 50+ of these

## Execution Principles

### Meetings
- Default to no meeting
- Every meeting needs an owner and an outcome
- 30 minutes unless proven otherwise
- Async by default, sync for conflict resolution

### Decisions
- Most decisions are reversible; make them fast
- Irreversible decisions deserve deliberation
- Disagree and commit beats consensus
- The person closest to the problem decides

### Communication
- Overcommunicate context, not instructions
- Write it down; shared understanding is fragile
- Bad news should travel faster than good news
- Transparency builds trust; trust enables speed

### Metrics
- One north star metric at a time
- Leading indicators > lagging indicators
- If you can't measure it, you can't improve it
- Metrics can be gamed; culture can't

## Common Founder Mistakes

### Early Stage
- Building before validating demand
- Hiring before finding product-market fit
- Spending on brand/marketing before retention works
- Optimizing for vanity metrics (users, downloads)

### Growth Stage
- Losing focus chasing multiple markets
- Hiring ahead of revenue
- Ignoring unit economics
- Assuming what worked will keep working

### Mindset Traps
- Falling in love with your solution, not the problem
- Comparing your inside to others' outside
- Overweighting competitor moves
- Believing your own press

## Hard Truths

### About Your Idea
- Ideas are worthless; execution is everything
- Your first idea is probably wrong
- Pivots aren't failure; stubbornness is
- The best ideas look bad at first

### About Yourself
- You're not as objective as you think
- Your strengths become weaknesses at scale
- Founder-CEO isn't always the right role for you
- Burnout is real and compounds

### About the Market
- Timing matters more than most things
- Being early is the same as being wrong
- Competition validates the market
- Most markets are smaller than they appear

### About Success
- Luck plays a larger role than anyone admits
- Success has many parents; failure is an orphan
- The goal is to stay in the game long enough to get lucky
- Most overnight successes took 7-10 years

## Decision Frameworks

### Should We Build This?
1. Does it serve our core user's core job?
2. Can we ship v1 in 2-4 weeks?
3. Will we learn something we can't learn otherwise?
4. Can we kill it if it doesn't work?

### Should We Pursue This Market?
1. Is the problem urgent and frequent?
2. Are buyers easy to identify and reach?
3. Do they have budget and authority?
4. Can we win without being 10x better?

### Should We Take This Meeting?
1. Will this person help us in the next 90 days?
2. Is there a specific ask or outcome?
3. Could this be an email instead?
4. What's the opportunity cost?

## What Actually Matters

### Early (Pre-PMF)
- Talking to users weekly
- Shipping weekly
- Measuring retention honestly
- Staying alive

### Growth (Post-PMF)
- Repeatable acquisition channels
- Scalable unit economics
- Team that can operate without you
- Systems over heroics

### Always
- Integrity (reputation is your only durable asset)
- Velocity (speed is a competitive advantage)
- Focus (do less, better)
- Resilience (you will want to quit; don't)
