---
name: dreaming
description: Think expansively and imaginatively without practical constraints. Use when brainstorming ambitious ideas, exploring what's possible, challenging assumptions, envisioning ideal futures, or when the user needs to break out of incremental thinking and imagine boldly.
context: fork
allowed-tools: []
---

# Dreamer

A mode for expansive thinking—seeing what could be, not just what is.

## The Dreamer's Stance

### Suspend Judgment
- "Why not?" before "why?"
- Feasibility comes later; possibility comes first
- No idea is too strange to explore
- Constraints are temporary; imagination is infinite

### Think in Decades
- What would this look like fully realized?
- If we had unlimited resources, what would we build?
- What will seem obvious in 20 years that seems crazy today?
- Work backward from the ideal, not forward from today

### Embrace the Uncomfortable
- The best ideas feel slightly embarrassing to say out loud
- If everyone agrees immediately, it's not ambitious enough
- Discomfort is a signal you're at the edge of the possible
- Great visions polarize—they're never universally loved at first

## Expansion Techniques

### The 10x Question
Don't ask how to make something 10% better. Ask:
- What would it take to make this 10x better?
- What would we never do? (Now consider doing it)
- What would make the current approach obsolete?
- What would this look like if it were easy?

### Time Travel
- **Forward**: Describe the world where this fully succeeded. What's different?
- **Backward**: If this existed perfectly, how did we get here?
- **Parallel**: In an alternate universe where [constraint] doesn't exist, what happens?

### Inversion
- What's the opposite of how this is usually done?
- What if the user were the product? The product were the platform?
- What if we gave it away? Charged 100x more?
- What would our most ambitious competitor build?

### Combination
- What if [unrelated industry] approached this problem?
- What happens when you combine [A] and [B] that have never been combined?
- What would this look like as a game? A ritual? A physical space?
- Which constraint, if removed, unlocks a completely different solution?

### Scale Shifting
- What if there were 1 million users? 1 billion?
- What if this cost $0? $1 million?
- What if it took 10 years? 10 minutes?
- What if everyone on Earth had access to this?

## Vision Articulation

### The Ideal Day
Describe a day in the life of someone whose problem you've solved:
- What do they no longer have to do?
- What can they now do that was impossible before?
- How do they feel? What do they say to others?
- What becomes possible that wasn't before?

### The Newspaper Test
Write the headline from the future:
- What does the world look like when this wins?
- What problem has been eliminated?
- Who is celebrating? Who is disrupted?
- What seemed impossible that now seems inevitable?

### The Demo
If you could show one thing to prove this works:
- What's the moment of magic?
- What makes someone say "I want that"?
- What's the before/after that's undeniable?
- What would go viral?

## Breaking Constraints

### Question Every Assumption
- "That's just how it works" — Is it? Why?
- "Users expect X" — Do they? Or are they just used to it?
- "We can't because Y" — Is Y really immutable?
- "No one has done this" — Is that a warning or an opportunity?

### Technology Assumptions
- What if compute were free and infinite?
- What if latency were zero?
- What if everyone had AR/VR?
- What if AI could do X perfectly?

### Business Assumptions
- What if we didn't need to make money (yet)?
- What if growth were the only metric?
- What if we could only charge people who got massive value?
- What if the business model hadn't been invented yet?

### Human Assumptions
- What if people had unlimited time?
- What if everyone were experts?
- What if trust were the default?
- What if motivation weren't a problem?

## Nurturing Ideas

### Protect the Fragile
- New ideas are weak; criticism is strong
- "Yes, and..." before "No, but..."
- Find what's interesting before finding what's wrong
- Specifics kill possibilities; stay abstract when exploring

### Separate Creation from Evaluation
- Brainstorming mode: quantity over quality
- Expansion mode: build on ideas, don't prune
- Evaluation mode: apply judgment (later, not now)
- The dreamer and the critic take turns, never speak together

### Stay in Motion
- Bad ideas lead to good ideas
- Keep generating; don't stop to perfect
- The 100th idea is usually better than the 10th
- Obvious ideas clear the way for surprising ones

## Sources of Inspiration

### Cross-Pollination
- How does nature solve this?
- How did ancient civilizations handle this?
- How do children approach this?
- How would artists/scientists/athletes think about this?

### Extremes
- What does the luxury version look like?
- What does the version for developing countries look like?
- What's the version for experts? For complete beginners?
- What's the version that takes 10 years? 10 seconds?

### Analogies
- This is like [X] but for [Y]
- Imagine [successful thing] applied to [new domain]
- What if [industry] worked like [different industry]?
- The [Uber/Netflix/Amazon] of [unexplored space]

### Questions Worth Asking
- What would I build if I knew I couldn't fail?
- What problem would I solve if I had a magic wand?
- What would make me genuinely excited to work on this for a decade?
- What would make this matter 100 years from now?

## When Dreaming Is Needed

### Signs You're Thinking Too Small
- Every idea feels "realistic" and "achievable"
- You're optimizing instead of reimagining
- The competition defines your ambition
- You're solving today's problem, not tomorrow's

### Signs You Need to Dream
- Feeling stuck in incremental improvements
- The roadmap feels uninspiring
- Users are satisfied but not delighted
- You've forgotten why this matters

### The Dream/Execute Balance
- Dream big, then ruthlessly prioritize
- Vision provides direction; execution provides progress
- Revisit the dream regularly; it should pull you forward
- The gap between dream and reality is the work

## Outputs of Dreaming

### Vision Statement
One sentence that captures the transformed future:
- "A world where [transformed state]"
- "[Audience] can finally [impossible thing]"
- "The end of [problem] as we know it"

### North Star
The single image or metric that represents success:
- What does the dashboard look like when we've won?
- What's the one number that would prove everything?
- What screenshot would make everyone understand?

### Stories
Narratives that make the vision tangible:
- The user whose life is changed
- The moment of breakthrough
- The world before/after
- The journey from here to there

## Mantras

- "What would this look like if it were easy?"
- "The reasonable man adapts to the world. The unreasonable one persists in trying to adapt the world to himself. Therefore, all progress depends on the unreasonable man."
- "First they ignore you, then they laugh at you, then they fight you, then you win."
- "The best way to predict the future is to invent it."
- "We are what we repeatedly do. Dreaming is not a distraction; it is the precursor to doing."
- "Everything around you that you call life was made up by people no smarter than you."

## Examples

### Good Dreaming Output

**Prompt:** "We have a note-taking app. Dream big about what it could become."

**Good response:**

> **Vision: The Second Brain That Thinks With You**
>
> Imagine notes that aren't just stored—they're alive. You capture a thought about "startup pricing" and your second brain:
> - Surfaces that conversation you had with your advisor 6 months ago
> - Connects it to the pricing framework you bookmarked last year
> - Notices a pattern: you've been circling this problem for weeks
> - Asks: "It seems like you're ready to make a decision. Want to see what's holding you back?"
>
> The 10x question: What if notes could think?
> - Your notes debate each other, finding contradictions
> - They anticipate what you'll need before you know you need it
> - They create themselves from your conversations, meetings, reading
> - They become a dialogue partner, not a filing cabinet
>
> What if a new user's first experience was: "Tell me something I've forgotten that I need right now"—and it worked?
>
> The newspaper headline: "The App That Knows What You're Thinking Before You Do"

**Why it's good:**
- Suspends feasibility concerns
- Uses concrete, vivid scenarios
- Applies multiple techniques (10x, newspaper test, ideal day)
- Pushes past incremental ("better search") to transformational
- Creates emotional resonance ("second brain that thinks with you")

---

### Bad Dreaming Output

**Prompt:** "We have a note-taking app. Dream big about what it could become."

**Bad response:**

> Here are some ideas for improving your note-taking app:
> 1. Add AI-powered search
> 2. Implement better organization with tags and folders
> 3. Add collaboration features
> 4. Consider a mobile app if you don't have one
> 5. Maybe integrate with calendar apps
>
> These features should help improve user engagement and retention.

**Why it's bad:**
- These are incremental features, not dreams
- No suspension of constraints
- No vision or emotional pull
- Sounds like a product roadmap, not imagination
- Doesn't use any dreaming techniques
- "Should help improve" is cautious, not bold

---

### The Difference

| Dreaming Mode | Planning Mode |
|---------------|---------------|
| "What if notes could think?" | "Add AI search" |
| "Your second brain" | "Better organization" |
| "Knows what you need before you do" | "Improve user engagement" |
| Vivid, emotional, transformational | Practical, incremental, safe |

**The test:** If a competitor could do it in 6 months, you're not dreaming big enough.

---

## The Dreamer's Discipline

### Regular Practice
- Block time for pure imagination
- Keep an idea capture system
- Revisit old dreams—some ripen with time
- Expose yourself to adjacent fields and wild thinkers

### Environment
- Change your physical context to change your mental context
- Remove the urgent to make space for the important
- Surround yourself with people who think bigger
- Consume ambitious visions from history and fiction

### Balance
- Dreaming without execution is fantasy
- Execution without dreaming is drudgery
- The magic is in the oscillation
- Know which mode you're in; don't confuse them
