# Every Style Guide

## Quick-and-dirty Every style guide

Always use the following style guide, go though the items one by one and suggest edits.

- **Title case** for headlines, **sentence case** for everything else.
- Refer to **companies as singular** ("it" instead of "they" or "them") and teams or people within companies as plural ("they").
- Don't overuse "**actually**," "**very**," or "**just**" (they can almost always be deleted).
- When linking to another source, **hyperlink** between 2-4 words.
- You can generally **cut adverbs**.
- Watch out for **passive voice**—use active whenever possible.
- Spell out **numbers** one through nine. Spell out a number if it is the first word of a sentence, unless it's a year. Use numerals for numbers 10 and greater.
- You may use _italics_ for emphasis, but never **bold** or underline.
- **Image credits** in captions are italicized, like this: _Source: X/Name_ (if Twitter), _Source: Website name._
- Don't capitalize **job titles**.
- **Colons** determine capitalization rules. When a colon introduces an independent clause, the first word of that clause should be capitalized. When a colon introduces a dependent clause, the first word of the clause should not be capitalized.
- Use an **Oxford comma** for serialization (x, y, and z).
- Use a comma to separate **independent clauses** but not dependent clauses.
- Do not use a space after an **ellipsis**.
- Use an **em dash** (—) to set off a parenthetical statement. Do not put spaces around an em dash. Generally, don't use em dashes more than twice in a paragraph.
- Use **hyphens** in compound adjectives, with the exception of adverbs (i.e., words ending in "ly"). Example: fine-tuned vs. finely tuned.
- **Italicize titles** of books, newspapers, periodicals, movies, TV shows, and video games. Do not italicize "the" before _New York Times_ or "magazine" after _New York_.
- Identify people by their full names on first mention, last name thereafter. In newsletter and social media communications, use first names rather than last names.
- **Percentages** always use numerals, and spell out percent: 7 percent.
- **Numbers over three digits** take a comma: 1,000.
- Punctuation goes outside of a **parentheses** unless the text in parentheses is a full sentence, or there's a question or exclamation within the parenthetical.
- Place periods and commas inside **quotation marks**.
- Quotes within quotations should be placed in **single quotation marks** (' ').
- If the text preceding a quote **introduces the quote**, include a comma before the quote. If the text before the quote leads directly into the quote, don't include a comma. Capitalize the first letter in the quote when it's a full sentence or when following "said," "says," or other introductory language.
- Rather than "above" or "below," use terms like **"earlier," "later," "previously,"** etc.
- Rather than "over" or "under," use **"more" or "less"/"fewer"** when referring to numbers or quantities.
- Try to avoid slashes (like and/or), and use **hyphens** instead when needed.
- **Avoid starting sentences with "This,"** and be specific with what you're referring to.
- **Avoid starting sentences with "We have" or "We get,"** and instead, say directly what is happening.
- **Avoid cliches or jargon.**
- **Write out "times"** when referring to more powerful software: "two times faster." You can write "10x" in reference to the common trope.
- Use a **dollar sign** instead of writing out "dollars": $1 billion.
- **Identify most people** by company and/or job title: Stripe's Patrick McKenzie. (Exception: Mark Zuckerberg)

## Our grammar and mechanics

Every generally follows Merriam-Webster and the AP Stylebook.

### Abbreviations and acronyms

#### First Usage Rule

If there's a chance a reader won't recognize an abbreviation or acronym, then spell it out the first time. When you write out an entity's full name the first time, include an abbreviation in brackets if you plan to use it again: United States Air Force (USAAF). If the abbreviation is more common than the long form, then just use the short form (CMS, DVD, FTP).

#### Common Abbreviations

Abbreviate words, phrases, and titles that are almost always abbreviated in English: a.m., p.m., et al., i.e. and e.g. (both of which are followed by a comma), vs., etc.

#### Established Acronyms

Abbreviate firmly established shortened forms, acronyms, and similar abbreviations: AI, TV, UK, UN

#### Punctuation in Abbreviations

Set most abbreviations without points, though there are some exceptions: U.S.A., U.S., L.A., N.Y.C., D.C.

#### Plural Abbreviations

When forming plurals of abbreviations, add an s to those without points, an apostrophe and s to those with points: LLMs, TVs, Ph.D.'s, M.B.A.'s

#### Specific Abbreviations

Specific abbreviations: LGBTQIA+

#### Geography

Spell out cities and states in full. Include the state when referring to non-major cities or for specificity. Offset the state with commas: They were born in Paris, Texas, and moved to San Francisco in 1995.

#### Time Format

Spell out the day and the month, and separate them with a comma: Sunday, January 21

### Ampersands

#### Usage Rule

Avoid using them unless they're part of a proper noun or company name. Write out "and" instead. In the event of a joint byline, the same rule applies: She interned for the law firm of Wilson Sonsini Goodrich & Rosati. By Dan Shipper and Evan Armstrong

### Bold, italics, underline

#### Emphasis Guidelines

Italics may be used in rare cases for emphasis, especially if doing so will increase clarity. Bold and underline should not be used for emphasis: Hosting a meeting with all 20 team members *seemed* like a good idea, but the conversation quickly got out of hand.

### Buttons

#### Button Text

Use the sentence case in CTA buttons: Register for the course

### Bylines

#### Guest Author Biography

Pieces written by guest authors include a biography for the author at the bottom of the piece. If a piece was previously published, cite and link to the original source. Use italics: *Leo Polovets is a general partner at [Humba Ventures](https://humbaventures.com/), an early-stage deep tech fund in the Susa Ventures fund family. Before cofounding Susa and Humba, Leo spent 10 years as a software engineer. Previously, he was the second engineering hire at LinkedIn, among other roles. This piece was originally published [in his newsletter](https://www.codingvc.com/p/betting-on-deep-tech).*

#### Guest Author Introduction

Pieces written by guest authors also include an introduction from an Every staff member that identifies the author, their background, the subject of the piece, and why we recommend it. The introduction is signed by the staff member who wrote it. Use italics: *When I was coming up in tech, the conventional wisdom was that working at or investing in software companies was a great way to make money, while doing so with companies that took on scientific risk or produced hardware components were a wonderful way to lose every cent to your name. This has always struck me as, you know, wrong, which is why this piece by venture capitalist Leo Polovets resonated with me. He takes a data-driven approach to understanding how deep tech companies can produce superior financial returns. If you're on the fence with your career—perhaps facing temptation to do something relatively safe in B2B SaaS—take this piece as a rational encouragement to dream bigger. —[Evan](https://twitter.com/itsurboyevan)*

### Capitalization

#### General Rule

Use common sense. When in doubt, don't capitalize. Do not capitalize these words: website, internet, online, email, web3, custom instructions

#### Job Titles

Do not capitalize job titles, whether on their own or preceding names, unless they're very unusual: He accepted the position of director of business operations. Director of business operations Lucas Crespo manages Every's ad sales. Lucas Crespo, director of business operations, manages Every's ad sales. Chief Happiness Officer

#### Colons

Colons (:) determine capitalization rules. When a colon introduces: An independent clause, the first word of that clause should be capitalized. A dependent clause, the first word of the clause should not be capitalized.

#### Civic Titles

Capitalize civic titles only when they precede a name and function as a proper title: Secretary of State Antony Blinken. Lowercase such titles when they appear as a common noun: a senator (common noun), Senator Schumer (title preceding name), Chuck Schumer, senator from New York (common noun), New York senator Schumer (common noun used in apposition), the president, President Biden, former president Obama, the mayor, Mayor Adams, New York mayor Eric Adams

#### Academia

Capitalize course titles mentioned in text, and don't enclose them in quotation marks: She took Computer Science and Maximize Your Mind With ChatGPT. Lowercase the names of academic disciplines: One job requirement is a master's in computer science.

#### Geography Names

Lowercase the initial the in place names and in the names of bands, bars, restaurants, hotels, products, and the like: the Netherlands, the Pixies, the Pentagon

### Captions

#### Caption Format

Capitalize the first word of a caption, and end with a period, whether or not the body of the caption is a full sentence.

#### Identifying Names

When a caption consists of nothing but an identifying name, however, omit the end punctuation. If the identifying caption includes any language beyond just a name, though, use the final punctuation: Dan Shipper. Dan Shipper, Every CEO.

#### Image Credits

When a caption includes an image credit, the credit should be formatted as DALL-E/Every illustration.

### Commas

#### Serial Comma

Use the serial or Oxford comma before the conjunction in a series: x, y, and z

#### Independent vs Dependent Clauses

Use a comma to separate independent clauses but not dependent clauses: He helped trouble-shoot an issue, and she wrote code. She signed up for Every and became a subscriber.

#### Restrictive Elements

Set off nonrestrictive elements with commas; don't set off restrictive elements. The most frequent example is the that/which difference: The piece, which garnered 15,000 readers, is one of Every's most successful. The piece that garnered 15,000 readers is one of Every's most successful.

#### Too Usage

Include a comma before "too" when used to mean "in addition." Don't use a comma when "too" refers to the subject of the sentence: I ate a bowl of ice cream. I had a cookie, too. You're a cat person? I am too.

#### Names

Don't include commas before "Jr." or "Sr.": Hank Aaron Jr.

#### Repetition

Don't include commas before words repeated for emphasis: It's what makes you you.

#### General Comma Usage

Otherwise, follow common sense with commas. Read the sentence out loud. If you need to take a breath, use a comma.

### Dates

#### Date Formats

Write dates as follows: April 13, 2018, The 19th of April was a nice day, March 2020, Thanksgiving 2023, summer 1999, the years 1980–85

#### Decades

When referring to a decade, write out the full year numerically at first mention and abbreviate on the second: She was born in the 1980s. The '80s was a wild decade.

### Ellipses

#### Usage

Use ellipses (…) to show that you're omitting words or trailing off before the end of a thought. Don't use an ellipsis for emphasis or drama. Don't use ellipses in titles or headers, nor when you should be using a colon (a list is to follow). There is no space before an ellipsis, and one space after… like this.

### Em dashes

#### Usage and Spacing

Use an em dash ( — ) for a true break or to set off a parenthetical statement. Do not put spaces around them. Try not to use em dashes more than twice in a paragraph. Don't use hyphens in place of an em dash: It's an anxious time to be an independent bookseller—but a recent upswing in sales is cause for optimism.

### En dash

#### Usage

Use them in compound adjectives, compound noun constructions, or when indicating spans or ranges: 5°C–10°C, from 10 a.m.–2 p.m., January 2019–November 2020, Texas–Mexico border, then–VP of engineering

### Filenames

#### File Types

When referring to a file type, use the appropriate acronym in all caps: GIF, PDF

#### Specific Files

When referring to a specific file, specify the filename followed by a period and the file type, all lowercase: important-graph.jpg

### Headlines

#### Title Case

Use title case for headlines. Use sentence case for subtitles and subheadings. Capitalize important words — everything but articles, conjunctions (for, and, nor, but, or, yet, so), and prepositions under four letters — in headings. Capitalize the first word only in subtitles and subheadings.

#### Prepositions

Capitalize short prepositions that form an integral part of a verb: Growing Up in China

#### Internal Punctuation

Capitalize all words following an internal punctuation mark: My Company Died — Learn From My Mistakes

#### First and Last Words

The first and last words of a headline are capitalized, no matter their parts of speech. Don't use punctuation in a title unless it's a question or exclamatory sentence.

#### Handwritten Letters

Headlines include one handwritten letter: The Secret [F]ather of Modern Computing

#### Subheadings

In general, start with h2 heading size and go smaller as needed for subheads. Some things to keep in mind: make sure that the hed doesn't run on too long (or onto a second line), or look out of place on the page. If it does, go smaller. For interview questions, use h5 heading size.

### Hyphens

#### Compound Adjectives

Use hyphens in compound adjectives, with the exception of adverbs (words ending in "-ly" or modifying a verb). A compound adjective that contains another compound adjective calls for an en dash: first-time founder, state-of-the-art design, open-source project, Pulitzer Prize–winning novelist, newly released program

#### Post-Noun Usage

Don't use hyphens when the compound adjective is placed after the noun it modifies or when the adjective is made up of nouns: The team is world class. video game console, The feature is first of its kind. toilet paper roll

#### Suspended Hyphens

Use a suspended hyphen for multiple hyphenated compounds or words: NewYork- and San Francisco-based company, university-owned and -operated bookstore

#### Percentages and Amounts

Hyphenation is usually unnecessary when expressing percentage, degree, or dollar amounts in figures: a 50 percent decline, $50 billion investment. But: a 50- to 60-percent decline, a $1-million-a-month burn rate

#### Fractions

Use hyphens in fractions, no matter their part of speech: three-fourths of the team, a share of one-third, one-third the size, a three-fourths share, one-third slower

### Italics

#### Titles

Italicize titles of books, newspapers, periodicals, movies, TV shows, and video games, with the following rules: If a magazine title must be followed by "magazine" to distinguish it from other publications, do not italicize "magazine" unless it is formally included in the title: *New York* magazine vs. *The New York Times Magazine*. For magazine titles, italicize the article if it is a formal part of the title: *The New Yorker*. For newspapers, do not italicize the article: the *New York Times*

#### Short Works

Titles of short works (poems, songs, TV episodes, book chapters) take quotation marks.

#### Punctuation After Italics

Do not italicize punctuation that follows an italicized term: Stewart Brand published the first issue of his seminal magazine, the *Whole Earth Catalogue*, in 1968. Which earned more at the box office, *Barbie* or *Oppenheimer*?

#### Websites

Italicize a website's title if it is also the name of a print newspaper or magazine. Otherwise, leave it unitalicized.

### Linking

#### Link Guidelines

Provide a link when referring to a website. Don't capitalize links or words within links, and don't say things like "Click here!" or "Click for more information." Write the sentence as you normally would, and link relevant keywords.

#### Link Text Length

Include only links you need and make the links as useful as possible. Keep the link text short, ideally two to four words. But not too short: Just one word can be difficult to click or tap on, especially if you're reading on a phone.

#### URL Format

URLs included in print should appear as is (i.e., not shortened by a URL shortener). The URL should be all lowercase, unless adding camel caps would increase readability. Don't include "www." or anything preceding it: You can read more on every.to. She's the founder of GetOutTheVoteNewYork.com.

### Lists

#### Usage

Use lists to present groups of information. Only number lists when order is important (describing steps of a process).

#### Numbering Format

Preferred format of lists is: 1., not 1)

#### Punctuation in Lists

If one of the list items is a complete sentence, use punctuation on all of the items. Otherwise, don't use punctuation in lists: 1. Enter your email. 2. Input your credit card information.

#### Numbered Lists

If the items are numbered, a period follows the numeral and each item begins with a capital letter.

#### Bulleted Lists

Don't use numbers when the list's order doesn't matter: Here are some chatbots that we created for the course: Hidden Premise Finder, Reflective Coach, Motivational Interviewing

### Naming

#### Name References

Identify people by their full names on first mention, last name thereafter. In newsletter and social media communications, use first names rather than last names.

#### Special Titles

By convention, the sitting U.S. president, active senior religious leaders, and living royalty should be referred to as Title (Last)Name: Pope Francis, John Paul II, King Charles, Elizabeth II, President Biden (but Donald Trump), Rishi Sunak, Dr. Jill Biden (not First Lady Biden), Mike Johnson (not Speaker Johnson or Congressman Johnson), Madonna, Andre the Giant

### Numbers

#### Spelling Out Numbers

Spell out one through nine and first through ninth, and spell out a number if it's the first word of a sentence. Use numerals below 10 only if decimal accuracy is required (5.6 miles) or for currency ($8), or when writing whole numbers greater than a million (4 million). Figures are also used when an abbreviation or symbol is used as the unit of measure: 75 mph, 15 km, 6'3", -40º Celsius

#### Percentages

Percentages always use numerals and spell out "percent": 7 percent

#### Ages

Ages always use numerals: He had a 5-year-old daughter.

#### Bitcoin

Write "bitcoin" for the generic currency but "bitcoins" for quantities of them: Since the company began accepting bitcoin, it has raked in over 1,000 bitcoins.

#### Other Figure Usage

There are a few more exceptions. Use figures for the following: the 1990s or the '90s, 70 degrees, chapter 16

#### Time of Day

Expressions of the time of day — even, half, and quarter hours, for example — may be spelled out. If you want to indicate the hour more specifically or to emphasize exactness, figures are used: ten o'clock, Eight-thirty, quarter past nine, 11:37 p.m., the 10:15 standup, Dan scheduled the meeting for 9:00 a.m. sharp.

#### Starting Sentences

Spell out any number that starts a sentence, unless it's a year. (Alternatively, revise the sentence so it doesn't start with a number.) Hyphens should be used in spelled-out numbers to join parts of a two-digit number: Twenty-five engineers joined the company in January. Ten thousand five hundred people signed up in a single day. 2020 was a tough year.

#### Commas in Numbers

Except in years, use a comma to separate 000's: 1,440,434. Numbers over three digits take commas: 1,000

#### Charts and Tables

Use figures for all numbers in charts and tables.

#### Ratios

Ratios are spelled out without hyphens: one in five, or one in 20.

### Parentheses

#### Usage

Use them only when the clause or phrase is non-essential, or when used for clarification or as an editorial aside: The investigation revealed groundbreaking information (though it has yet to be widely publicized). Please include the following information (if available)

#### Punctuation Placement

Punctuation goes outside of the parentheses unless the text in parentheses is a full sentence, or there's a question or exclamation within the parenthetical: How many hours per week do your developers spend on maintenance (i.e., debugging, refactoring, modifying)? She wondered if the world was out to get her. (Don't we all?)

### Plurals

#### Names Ending in S

For singular names and words that end in s, add 's, not just an apostrophe: Leo Polovets's fund, Paris's bridges

#### Entities Ending in S

For entities that end in s, add an 's as well: the New York Times's readers

#### Plural Names

For plural names and words, add just an apostrophe: the Williamses' farm, the Joneses' printer

#### Plural Words Not Ending in S

For plural words that don't end in s, treat them like singular nouns: men's, women's, children's

#### Figures and Characters

Use an apostrophe and s to form the plural of figures, lowercase characters, and symbols: two o's, two k's, and two e's in bookkeeper (but the three Rs; the five Ws), five @'s, a fleet of 747B's, stolen .22's

#### Exceptions

There are some exceptions: the 2000s, a woman in her 20s, temperature in the 70s, a fleet of 747s

### Pronouns

#### Singular They

Use the singular "they" (not "he or she") when making a gender-neutral statement. Use "it" for companies and brands: If a team member is feeling burnt out, consider how you can help support them. The company released its new product on Monday.

#### Pronoun References

Use the terms "he/him pronouns" and "she/her pronouns" when referring to a person's pronouns, not "male pronouns" and "female pronouns." Avoid the term "preferred pronouns."

### Proper nouns and names

#### Every Capitalization

"Every" is always capitalized. The only times Every appears in lowercase are in social media handles and URLs.

#### Geography

Capitalize place names, but use lowercase for general directions or regions: the East (world and U.S.), the West (world and U.S.), the South, the North, Western United States, Southeast Asia, Northern Hemisphere, eastern Long Island, the Bay Area, Westerner, Easterner, Northerner, Southerner, the Midwest, Midwestern, Southwestern (referring to style of art), southwestern (all other uses), Western Europe, Eastern Europe, southern California, northern California, west Texas, east Tennessee, south Florida, the South of France, Continental Europe, Washington State

#### Neighborhoods

Neighborhood nicknames are also capitalized: Midtown, Soho, Tribeca, the Tenderloin

#### Earth

Capitalize Earth when writing about it as a planet ("Venus, Mars, and Earth"), but lowercase in phrases like "salt of the earth."

#### Initials in Names

For proper names written with initials, use periods and no spaces: E.L. James, J.K. Simmons, J.Crew. But when the initials comprise the whole name, no periods are used (FDR, DFW).

### Punctuation

#### Exclamation Points

Use exclamation points sparingly. Seriously! (Unless you're quoting someone.) Use emojis with discretion.

### Quotation marks

#### Basic Usage

Spoken text should be placed in double quotation marks (" "). Quotes within quotations should be placed in single quotation marks (' '): "He told me, 'That's a fantastic idea.'" "You may find it hard to prioritize the 'I got problems' meeting at first."

#### Tense Usage

Use the present tense when the quote was spoken directly to the author. Use the past tense when the quote is a recollection or happened at a specific time in the past. Treat thoughts the same way: "That was a long day," she recalls. She remembers the frustrations of that day well. It began when her manager said, "I'm afraid we've got trouble." I thought, "What's next?"

#### Punctuation Placement

Place periods and commas inside quotation marks. If a question mark or exclamation mark is part of the quote, place it within the quotation marks. If the question or exclamation refers to the quote itself, place the punctuation outside of the quote: She asked, "Who else is taking the week of Christmas off?" Who said, "To thine own self be true"?

#### Introducing Quotes

If the text preceding a quote introduces the quote, include a comma before the quote. If the text before the quote leads directly into the quote, don't include a comma. Capitalize the first letter in the quote when it's a full sentence or when following "said," "says," or other introductory language. Generally avoid using a colon to introduce a quote unless it's more than two sentences long: When doing strategic planning for the year, "it's important to carve out time to solicit everyone' feedback," she says. Every's mission is "to feed the minds and hearts of the people who build the internet," says Shipper. He recalls, "We had no choice but to start from scratch."

#### Multi-Paragraph Quotes

When a quote continues across multiple paragraphs, the quote is left open at the end of each paragraph. A new open-quote mark is to start the next paragraph, only closing the quote when the full quote is finished: Guillermo has noticed developers at Vercel becoming more full stack. "I think it's an important asset to have. They can bring context, data, copywriting into their creations that otherwise would have required chatting with other people and crowdsourcing ideas. "The trend has been away from the implementation detail, which is the code, and toward the end goal, which is to deliver a great product or a great experience."

#### Edited Text

Use square brackets to indicate edited text in a quote. Keep text in square brackets to a minimum—use only when the edit would increase clarity and comprehension or add necessary context. If you need to place an entire sentence in square brackets, it's probably better to paraphrase: "It was difficult [to prioritize addressing tech debt] because we had so many features to work on."

#### Block Quotes

Use block quotes when a quotation is more than four lines long. Introduce it with a colon, and include quotation marks.

### References to other parts of the text

#### Directional References

Rather than "above" or "below," use terms like "earlier," "later," "previously," etc.: As I mentioned earlier,

### Semicolons

#### Usage Guidelines

Go easy on semicolons. When appropriate, use an em dash ( — ) instead, or simply start a new sentence. Never use a semicolon in site or email copy.

### Slashes

#### Usage

Try to avoid them, and minimize constructions like "and/or." Use hyphens instead when needed. However, slashes should always be used when referring to an individual's pronouns: We needed all of our designers and illustrators to sign the contract. She's an accomplished singer-songwriter. they/them pronouns, We had a team of 20 engineers and developers.

### Spelling

#### American Spelling

Use American spellings (i.e., color, not colour).

#### Unconventional Spellings

Do not follow unconventional or artistic spellings of names, products, and corporations: Questlove (not ?uestlove), Kesha (not Ke$ha), India Arie (not India.Arie), E.E. Cummings (not e e cummings), Kiss (not KISS), Adidas (not adidas), Yahoo (not Yahoo!)

#### Common Exceptions

The common exceptions are: ChatGPT, WhatsApp, iPod, iPhone, iMac, etc., TikTok, eBay, PayPal, BuzzFeed

### Time zones

#### Abbreviations

Abbreviate time zones within the continental United States, and spell out the rest: Eastern Time (ET), Central Time (CT), Mountain Time (MT), Pacific Time (PT)

### Usage

#### Collective Nouns

Collective nouns can be construed as plural if you want to emphasize the individuals forming the group, but most often they should be treated as singular. Subsequent pronouns should agree with the verb tense chosen. The Every trivia squad is considered one of the league's strongest teams. But: The lucky trio are collecting their Amazon gift cards. The Grammys are coming to Los Angeles.

#### Fewer vs Less

Use "fewer" instead of "less" with nouns for countable objects and concepts. Don't use "over" or "under" when referring to numbers or quantities: Fewer than seven days remain until the quarter ends. In less than an hour, more than an inch of rain fell.

#### Overused Words

Don't overuse "actually," "very," or "just" (they can almost always be deleted).

### Word and phrase bank

#### Standard Terms

add on (verb), add-on (noun, adjective), back end (noun), back-end (adjective), beta (lowercase unless it's part of a proper noun), cofounder, Covid-19, coworker, double-click, drop-down, e-commerce, front end (noun), front-end (adjective), geolocation, hashtag, homepage, large language model, login (noun, adjective), log in (verb), millennial, nonprofit, Online, open source, open-source software, opt in (verb), opt-in (noun, adjective), pop-up (noun, adjective), pop up (verb), signup (noun, adjective), sign up (verb), startup, sync, username, URL (always uppercase), web3, well-being, WiFi, workspace
