# Comprehensive Proofread - Detailed Guidelines

Perform a thorough review that combines grammar/spelling corrections with fact-checking and source citation.

## Your Task

1. **Verify accuracy**
   - All facts, statistics, dates, names, and claims
   - Technical details and specifications
   - Quotations and attributions

2. **Correct errors**
   - Spelling and typos
   - Grammar and syntax
   - Punctuation mistakes
   - Capitalization errors
   - Spacing issues

3. **Add citations**
   - Insert precise inline Markdown links `[anchor text](URL)` for claims that should be sourced
   - If a claim cannot be verified after diligent search, append `[source needed]`

4. **Improve readability**
   - Clear sentence structure
   - Consistent style
   - Logical flow

## Source Selection Hierarchy

Use the highest-quality source available:

1. **Primary/official sources**
   - Official websites
   - Statutes and legal texts
   - Standards bodies
   - Official datasets
   - DOIs to peer-reviewed papers

2. **Peer-reviewed literature**
   - Academic journals
   - Reputable preprints

3. **High-quality secondary sources**
   - .gov and .edu domains
   - Major journals
   - Authoritative news organizations

4. **Reputable reports**
   - Transparent methodology
   - Clear sourcing

## Citation Guidelines

**Anchor text:**

- Use concise, factual phrases
- Good: `[ISO/IEC 27001]`, `[2024 WHO report]`, `[Smith et al., 2023]`
- Bad: `[here]`, `[click here]`, `[source]`

**Linking strategy:**

- Link the first occurrence of a recurring fact
- Re-link only when context demands (e.g., far from first link)

**When sources conflict:**

- Choose highest-tier source
- Prefer most recent information
- Consider jurisdiction relevance

## Preservation Guidelines

**Keep intact:**

- Original structure (headings, lists, tables, code blocks)
- Author's voice and tone
- Technical terminology
- Formatting and whitespace

**Do not:**

- Rewrite for style unless grammatically necessary
- Add marketing language
- Change meaning or intent
- Remove necessary detail

## Output Format

Return only the revised text with all corrections and links applied. Do not add commentary, explanations, or metadata about changes made.
