# Git Workflow Examples

Standalone example scenarios extracted from the comprehensive examples reference.
Each example demonstrates specific workflow patterns and decision points.

## Examples

1. **[minimal-feature-commit/](minimal-feature-commit/)** - Simple workflow
2. **[multi-commit-refactor/](multi-commit-refactor/)** - Complex changes
3. **[messy-history-cleanup/](messy-history-cleanup/)** - History cleanup
4. **[protected-branch-handling/](protected-branch-handling/)** - Phase 0 safety
5. **[quality-review-phase/](quality-review-phase/)** - Quality checks

## How to Use

Each example contains:

- `scenario.md` - The situation and goals
- Workflow files - Step-by-step walkthrough
- `commands.sh` - Copy-pasteable commands

## Comprehensive Reference

For all 12 detailed examples with full narrative, see:
[../examples.md](../examples.md)

These standalone examples extract common patterns for quick reference.
