# Hacker News Show HN Templates

## Title Format

Always use "Show HN:" prefix:
```
Show HN: [Product Name] – [Brief description]
```

Examples:
- Show HN: Volume – Simple strength training tracker
- Show HN: I built a CLI tool to manage dotfiles
- Show HN: Open source alternative to [Popular Product]

Keep title under 80 characters.

## Body Template

```
Hey HN,

[2-3 sentences on why you built this - the problem you faced]

[Product Name] is [brief description]. Key features:

- [Feature 1]
- [Feature 2]
- [Feature 3]

[Optional: 1-2 sentences on tech stack - HN appreciates this]

[Optional: What you learned or challenges faced]

Happy to answer any questions.

[URL]
```

## Example

```
Hey HN,

I'm a weightlifter who got frustrated with fitness apps. They all want to track calories, sleep, water, AND workouts. I just wanted to remember my last bench press weight.

Volume is a minimal strength training tracker:

- Log exercises, weights, reps
- See progress charts over time
- Simple rest timer

Built with Next.js, TypeScript, and Convex (real-time database). The whole thing is about 5k lines of code.

Learned a lot about building mobile-first web apps - happy to discuss the PWA approach vs native.

https://volume.app
```

## Best Practices

### DO:
- Be genuine and technical
- Share what you learned
- Answer all comments (even critical ones)
- Post Tuesday-Thursday, 9am EST
- Accept constructive criticism gracefully

### DON'T:
- Use marketing speak ("revolutionary", "game-changing")
- Ask for upvotes (bannable offense)
- Get defensive in comments
- Post on weekends (lower traffic)
- Ignore criticism

## Comment Response Template

When someone asks a technical question:
```
Good question. [Direct answer]

[Brief elaboration if needed]

[Optional: what you considered and why you chose this approach]
```

When someone is critical:
```
Fair point. [Acknowledge their concern]

[Explain your reasoning OR agree and note it for improvement]

Thanks for the feedback.
```

## Timing

Best times to post:
- Tuesday-Thursday
- 9am-11am EST
- Avoid: Fridays, weekends, holidays

Stay online for 2-3 hours after posting to respond to comments.
