# Reddit Launch Post Templates

## General Format

```
TITLE:
[I built/I made/Introducing] [Product] - [what it does]

BODY:
[Personal context - why you built this]

[What it does - 2-3 sentences]

[Features list - bullet points]

[Link]

[Question to encourage engagement]
```

## Template: Side Project (r/SideProject, r/webdev)

```
TITLE:
I built [Product] - [brief description] [Show Off Saturday]

BODY:
Hey everyone! Just finished my latest side project.

**What it is:**
[Product] is [description]. I built it because [personal reason].

**Tech stack:**
- Frontend: [framework]
- Backend: [technology]
- Hosting: [platform]

**Features:**
- [Feature 1]
- [Feature 2]
- [Feature 3]

**Link:** [url]

What do you think? Any suggestions for improvements?
```

## Template: Domain-Specific (r/fitness, r/productivity, etc.)

```
TITLE:
I built a simple [product type] because every app was too [problem]

BODY:
I've been [doing relevant activity] for [time]. Every [existing solution] I tried was [problem with existing solutions].

So I built my own.

**[Product Name]** does one thing: [core function]. That's it.

Features:
- [Feature 1]
- [Feature 2]
- [Feature 3]

It's [free/pricing]. No [thing you don't do].

Link: [url]

**Question for the community:** [genuine question about their preferences]
```

## Template: Indie/Startup (r/EntrepreneurRideAlong, r/startups)

```
TITLE:
🚀 Launched [Product] - [tagline] + learnings from the build

BODY:
Just launched [Product] and wanted to share.

**The Problem:**
[Describe the problem you're solving]

**The Solution:**
[What you built and why it's different]

**The Stack:**
- [Technology choices]
- Monthly cost: $X

**What I Learned:**
1. [Lesson 1]
2. [Lesson 2]

**What's Next:**
[Your plans]

Link: [url]

Would love any feedback or questions!
```

## Relevant Subreddits by Product Type

### Developer Tools
- r/SideProject
- r/webdev
- r/programming
- r/opensource

### Productivity
- r/productivity
- r/getdisciplined
- r/SideProject

### Fitness
- r/fitness
- r/GYM
- r/strength_training
- r/bodybuilding

### Games
- r/IndieGaming
- r/playmygame
- r/gamedev

### Startups
- r/startups
- r/EntrepreneurRideAlong
- r/SaaS
- r/Entrepreneur

## Best Practices

### DO:
- Read subreddit rules before posting
- Use appropriate flair
- Engage with every comment
- Be authentic, not salesy
- Cross-post only to truly relevant subreddits
- Post during peak hours for that subreddit

### DON'T:
- Spam multiple subreddits at once
- Use clickbait titles
- Ignore comments
- Get defensive about criticism
- Self-promote more than 10% of your posts
- Violate subreddit-specific rules

## Timing

- Check subreddit traffic patterns
- Generally: weekday mornings/lunch
- Use "Show Off Saturday" threads where applicable
- Some subreddits have specific days for self-promo

## Responding to Comments

Positive feedback:
```
Thanks! [Brief acknowledgment]
```

Feature request:
```
Great idea! [Note whether you'll consider it]
```

Criticism:
```
Fair point. [Acknowledge without being defensive]
```

Comparison to competitors:
```
Good comparison. [Honest differentiator, not bashing competitor]
```
