---
name: github-marketing
description: When the user wants to use open source as a distribution strategy, grow on GitHub, convert README traffic, design open-core, or build community-led funnels (stars, deploys, sponsors, plugins).
effort: high
---

# GitHub Marketing

## Purpose

Turn GitHub attention into real users, community, and revenue without eroding trust.

## When to Use

- Open source as a distribution strategy or open-core planning
- Grow GitHub traction (stars, installs, contributors, sponsors)
- Convert README traffic into deploys or signups
- Design community-led funnels or plugin ecosystems

## Core Principles

### 1. Open Core Clarity
Make the boundary obvious:
- What is free forever
- What is paid and why
- No surprise lockouts

### 2. 10-Second Time-to-Value
If it takes >10s to see value, you lose. Reduce steps, give defaults, add deploy buttons.

### 3. Trust Before CTA
Open source is credibility marketing. Earn trust before asking for upgrade.

### 4. Loops, Not One-Offs
Stars → users → contributors → referrals. Build loops, not launches.

### 5. Community as Product Surface
Docs, examples, templates, and plugins are product. Treat them as such.

## Workflow Summary

1. Run discovery using initial assessment + questions. See `references/assessment.md` and `references/questions.md`.
2. Pick distribution playbooks. See `references/playbooks.md`.
3. Choose metrics to track. See `references/metrics.md`.
4. Produce artifacts in the required format. See `references/output-format.md`.

## Related Skills

- **programmatic-seo**: If you need scalable GitHub Pages content
- **copywriting**: For README and launch copy
