# Contributing Guide (Growth-Oriented)

Thanks for contributing. Every contribution helps the project grow.

## Quick Start

```bash
git clone https://github.com/OWNER/REPO.git
cd REPO
make dev
```

## Where to Start

- `good first issue`
- `help wanted`
- Docs fixes and examples
- New integrations or micro-plugins

## How to Get Help

- GitHub Discussions: LINK
- Discord/Slack: LINK
- Office hours: LINK

## Contribution Types We Love

- Bug fixes with reproduction
- Docs or tutorial improvements
- Performance wins with metrics
- Templates, starter kits, examples
- Ecosystem plugins (Shopify, Chrome, Slack)

## Growth-Friendly Guidelines

- Prefer small PRs with clear intent
- Add a short demo or screenshot
- Link to issue or discussion
- Include release note line

## PR Checklist

- [ ] Tests added/updated
- [ ] Docs updated
- [ ] Changelog entry added
- [ ] Security impact reviewed

## Recognition

We shout out contributors in release notes and socials. Add your handle in the PR if you want a mention.

## Code of Conduct

We follow CODE_OF_CONDUCT.md. Be kind, be clear.
