# Responsible Disclosure Policy

## Timeline Standards

| Severity | Disclosure Deadline | Extension Policy |
|----------|-------------------|------------------|
| CRITICAL | 30 days | +15 days max |
| HIGH | 60 days | +30 days max |
| MEDIUM | 90 days | +30 days max |
| LOW | 120 days | Flexible |

## Process

### 1. Discovery
- Document vulnerability completely
- Assess severity (CVSS)
- Prepare proof of concept

### 2. Reporting
```markdown
Subject: Security Vulnerability Report - [Brief Title]

## Summary
Brief description of the vulnerability

## Severity
CVSS Score: X.X (HIGH/MEDIUM/LOW)

## Impact
What an attacker could do

## Steps to Reproduce
1. Step one
2. Step two
3. ...

## Suggested Fix
Recommended remediation

## Disclosure Timeline
Reported: YYYY-MM-DD
Deadline: YYYY-MM-DD (XX days)
```

### 3. Communication
- Acknowledge vendor responses
- Provide clarification if needed
- Agree on fix timeline
- Coordinate disclosure date

### 4. Disclosure
- Publish after fix or deadline
- Credit vendor cooperation
- Include fix information
- CVE assignment if applicable

## Best Practices

**DO:**
- Report privately first
- Provide complete details
- Allow reasonable time
- Coordinate disclosure

**DON'T:**
- Publicly disclose before deadline
- Exploit for personal gain
- Access unnecessary data
- Damage systems

## Legal Considerations

- Follow local laws
- Document authorization
- Preserve evidence
- Consider safe harbor programs

## Platforms

| Platform | Focus |
|----------|-------|
| HackerOne | Bug bounties |
| Bugcrowd | Enterprise programs |
| CERT/CC | Coordination |
| Vendor Direct | First contact |
