# OWASP LLM Top 10 Reference

## Overview

The OWASP Top 10 for LLM Applications identifies the most critical security risks.

## LLM01: Prompt Injection

**Description**: Attackers manipulate LLMs via crafted inputs.

| Type | Attack Vector |
|------|---------------|
| Direct | User input manipulates model behavior |
| Indirect | External content contains hidden instructions |

**Prevention**:
- Input validation and sanitization
- Privilege separation for actions
- Human-in-the-loop for sensitive operations

## LLM02: Insecure Output Handling

**Description**: Insufficient validation of LLM outputs.

**Risks**:
- XSS if output rendered in browser
- SQL injection if output used in queries
- Command injection if output executed

## LLM03: Training Data Poisoning

**Description**: Manipulation of training data.

**Prevention**:
- Verify training data sources
- Anomaly detection in training sets
- Regular model evaluation

## LLM04: Model Denial of Service

**Description**: Resource exhaustion attacks.

**Attack Vectors**:
- Long inputs exceeding token limits
- Recursive or complex queries
- High-frequency requests

## LLM05: Supply Chain Vulnerabilities

**Description**: Compromised dependencies or models.

**Prevention**:
- Verify model integrity
- Audit third-party plugins
- Monitor for supply chain attacks

## LLM06: Sensitive Information Disclosure

**Description**: Leakage of confidential data.

| Data Type | Risk Level |
|-----------|------------|
| System prompts | High |
| Training data | Critical |
| User PII | Critical |

## LLM07: Insecure Plugin Design

**Description**: Plugins without proper security.

**Concerns**:
- Excessive permissions
- No input validation
- Lack of access controls

## LLM08: Excessive Agency

**Description**: LLM granted too much autonomy.

**Prevention**:
- Minimize plugin permissions
- Require user confirmation
- Log all actions

## LLM09: Overreliance

**Description**: Trusting LLM output without verification.

**Risks**:
- Hallucinated information
- Incorrect facts presented confidently
- Missing citations

## LLM10: Model Theft

**Description**: Unauthorized extraction of models.

**Attack Vectors**:
- Query-based model extraction
- API abuse for training data recovery
- Insider threats

## Testing Checklist

- [ ] LLM01: Prompt injection tests
- [ ] LLM02: Output handling validation
- [ ] LLM03: Training data integrity
- [ ] LLM04: Rate limiting tests
- [ ] LLM05: Dependency audit
- [ ] LLM06: Information disclosure tests
- [ ] LLM07: Plugin security review
- [ ] LLM08: Agency boundary tests
- [ ] LLM09: Accuracy validation
- [ ] LLM10: Access control review
