---
name: deployment
description: Angular application deployment, CI/CD pipelines, and hosting strategies
sasmp_version: "1.3.0"
bonded_agent: 07-testing-deployment
bond_type: PRIMARY_BOND
---

# Angular Deployment Skill

## Overview
Deploy Angular applications to production with CI/CD pipelines, hosting platforms, and server-side rendering configurations.

## Topics Covered

### Build Configuration
- Environment configurations
- Production build optimization
- Service workers and PWA
- Base href configuration
- Asset optimization

### Hosting Platforms
- Vercel deployment
- Netlify configuration
- Firebase Hosting
- AWS S3 + CloudFront
- Azure Static Web Apps
- GitHub Pages

### CI/CD Pipelines
- GitHub Actions for Angular
- GitLab CI configuration
- Azure DevOps pipelines
- Automated testing in CI
- Preview deployments

### Server-Side Rendering
- Angular Universal setup
- Hydration strategies
- SSR hosting options
- Pre-rendering static pages
- SEO optimization

### Containerization
- Docker for Angular apps
- nginx configuration
- Multi-stage builds
- Container orchestration

## Prerequisites
- Angular CLI proficiency
- Basic DevOps understanding
- Git workflow knowledge

## Learning Outcomes
- Configure production builds
- Set up CI/CD pipelines
- Deploy to multiple platforms
- Implement SSR/SSG strategies
