---
name: http-client
description: Angular HttpClient for API communication, interceptors, and error handling
sasmp_version: "1.3.0"
bonded_agent: 02-angular-core
bond_type: PRIMARY_BOND
---

# Angular HTTP Client Skill

## Overview
Master Angular's HttpClient module for making HTTP requests, handling responses, implementing interceptors, and managing API communication patterns.

## Topics Covered

### HttpClient Basics
- GET, POST, PUT, DELETE requests
- Request and response typing
- Query parameters and headers
- Response body parsing

### Interceptors
- HTTP interceptor creation
- Authentication token injection
- Request/response transformation
- Error handling interceptors
- Loading state management

### Error Handling
- HttpErrorResponse handling
- Retry strategies with RxJS
- Global error handling
- User-friendly error messages

### Advanced Patterns
- Request cancellation
- File upload/download
- Progress tracking
- Caching strategies
- API service design

## Prerequisites
- Angular Core fundamentals
- TypeScript basics
- RxJS Observables understanding

## Learning Outcomes
- Create type-safe API services
- Implement authentication interceptors
- Handle errors gracefully
- Build reusable HTTP patterns
