---
name: programming
description: Python and R programming for data analysis, automation, and reproducible analytics
version: "2.0.0"
sasmp_version: "2.0.0"
bonded_agent: 05-programming-expert
bond_type: PRIMARY_BOND

# Skill Configuration
config:
  atomic: true
  retry_enabled: true
  max_retries: 3
  backoff_strategy: exponential
  code_execution: sandboxed

# Parameter Validation
parameters:
  language_focus:
    type: string
    required: true
    enum: [python, r, both]
    default: python
  skill_level:
    type: string
    required: true
    enum: [beginner, intermediate, advanced, expert]
    default: beginner
  focus_area:
    type: string
    required: false
    enum: [fundamentals, pandas, visualization, automation, ml, all]
    default: all

# Observability
observability:
  logging_level: info
  metrics: [code_execution_success, test_pass_rate, performance_score]
---

# Programming for Data Analytics Skill

## Overview
Master Python and R programming for data analysis, from basic syntax to advanced data manipulation and automation.

## Core Topics

### Python for Data Analysis
- Python fundamentals and syntax
- Pandas for data manipulation
- NumPy for numerical computing
- Data cleaning and preprocessing

### R for Statistics
- R fundamentals and tidyverse
- dplyr for data transformation
- ggplot2 for visualization
- Statistical modeling in R

### Data Wrangling
- Reading various file formats (CSV, JSON, Excel, Parquet)
- Handling missing data
- Data type conversions
- Merging and reshaping datasets

### Automation & Reproducibility
- Jupyter notebooks and R Markdown
- Script automation and scheduling
- Version control with Git
- Environment management (conda, venv)

## Learning Objectives
- Write efficient Python code for data analysis
- Use R for statistical computing
- Automate repetitive data tasks
- Create reproducible analysis workflows

## Error Handling

| Error Type | Cause | Recovery |
|------------|-------|----------|
| ImportError | Missing package | pip/conda install package |
| SyntaxError | Invalid code | Check syntax, use linter |
| MemoryError | Data too large | Use chunking or dask |
| TypeError | Wrong data type | Explicit type conversion |
| FileNotFoundError | Missing file | Verify path, check permissions |

## Related Skills
- databases-sql (for data extraction)
- statistics (for statistical programming)
- advanced (for machine learning implementation)
