---
name: "Python Basics"
description: "Master Python syntax, data types, functions, and libraries basics for data analysis automation"
category: "Programming"
level: "Beginner"
duration: "4-5 weeks"
---

# Python Basics

## Quick Start

Python is the primary language for data analysts. Within your first week, you'll write scripts, use variables and functions, and load data. By week three, you'll automate routine tasks and connect to APIs without manual intervention.

**First Task (30 minutes):**
1. Install Python and Jupyter Notebook (Anaconda distribution)
2. Write a simple script: calculate average of a list
3. Create a function that reads a CSV file
4. Run your first automation task

## Key Concepts

### 1. Python Fundamentals
**What it is:** Core language syntax and how Python works.

**Variables & Data Types:**
```python
# Strings (text)
name = "John"
message = 'Hello, ' + name

# Numbers
count = 42
price = 19.99
total = count * price

# Lists (ordered, mutable)
products = ["apple", "banana", "orange"]
prices = [1.5, 0.75, 2.0]
products.append("grape")

# Dictionaries (key-value pairs)
customer = {"name": "John", "age": 30, "city": "NYC"}
print(customer["name"])  # Output: John

# Tuples (ordered, immutable)
coordinates = (10.5, 20.3)

# Boolean
is_active = True
has_discount = False
```

**Control Flow:**
```python
# If/else statements
if age >= 18:
    print("Adult")
elif age >= 13:
    print("Teen")
else:
    print("Child")

# Loops
for product in products:
    print(product)

for i in range(5):  # 0, 1, 2, 3, 4
    print(i)

while count > 0:
    print(count)
    count -= 1

# List comprehension (concise loops)
squares = [x**2 for x in range(5)]  # [0, 1, 4, 9, 16]
```

### 2. Functions & Modules
**What it is:** Reusable blocks of code and external libraries.

**Writing Functions:**
```python
def greet(name, greeting="Hello"):
    """Function that greets someone.

    Args:
        name: Person's name
        greeting: Custom greeting (default: "Hello")

    Returns:
        Greeting string
    """
    return f"{greeting}, {name}!"

print(greet("John"))               # Hello, John!
print(greet("John", "Hi"))         # Hi, John!

# Functions can return multiple values
def get_stats(data):
    return min(data), max(data), sum(data) / len(data)

minimum, maximum, average = get_stats([10, 20, 30, 40])
```

**Working with Modules:**
```python
# Import entire module
import math
result = math.sqrt(16)  # 4.0

# Import specific function
from math import sqrt
result = sqrt(16)

# Import with alias
import pandas as pd

# View available functions
help(math)
```

### 3. File Operations
**What it is:** Reading and writing data to files.

**Reading Files:**
```python
# Simple text file
with open('data.txt', 'r') as file:
    content = file.read()
    print(content)

# Read line by line
with open('data.txt', 'r') as file:
    for line in file:
        print(line.strip())

# CSV files (with pandas, covered in next skill)
import pandas as pd
df = pd.read_csv('data.csv')
```

**Writing Files:**
```python
# Write text to file
with open('output.txt', 'w') as file:
    file.write("Line 1\n")
    file.write("Line 2\n")

# Append to file
with open('output.txt', 'a') as file:
    file.write("Line 3\n")
```

### 4. Error Handling
**What it is:** Managing problems that occur during execution.

**Try/Except:**
```python
try:
    age = int(input("Enter your age: "))
    if age < 0:
        raise ValueError("Age cannot be negative")
except ValueError:
    print("Please enter a valid number")
except ZeroDivisionError:
    print("Cannot divide by zero")
finally:
    print("Processing complete")

# Example: Loading a file that might not exist
try:
    with open('data.csv', 'r') as f:
        data = f.read()
except FileNotFoundError:
    print("File not found. Please check the path.")
```

### 5. Data Analysis with Python
**What it is:** Libraries that make analysis easier and faster.

**Essential Libraries:**
```python
# NumPy: Numerical computing
import numpy as np
array = np.array([1, 2, 3, 4, 5])
print(np.mean(array))    # 3.0
print(np.std(array))     # Standard deviation

# Pandas: Data manipulation (covered in next skill)
import pandas as pd
df = pd.read_csv('data.csv')
print(df.head())         # First 5 rows
print(df.describe())     # Summary statistics

# Matplotlib: Plotting (visualization)
import matplotlib.pyplot as plt
plt.plot([1, 2, 3], [1, 4, 9])
plt.xlabel('X')
plt.ylabel('Y')
plt.show()

# Requests: HTTP requests for APIs
import requests
response = requests.get('https://api.example.com/data')
data = response.json()
```

**Example: Complete Analysis Script:**
```python
import pandas as pd
import numpy as np

# Load data
df = pd.read_csv('sales.csv')

# Clean data
df = df.dropna()  # Remove rows with missing values

# Calculate statistics
total_sales = df['amount'].sum()
average_sale = df['amount'].mean()
highest_sale = df['amount'].max()

# Filter data
high_value = df[df['amount'] > 1000]

# Save results
results = {
    'total': total_sales,
    'average': average_sale,
    'maximum': highest_sale,
    'high_value_count': len(high_value)
}

print(results)
```

## Tools and Resources

**Installation & Setup:**
- Anaconda: Package manager with all essentials (anaconda.com)
- Python.org: Official Python downloads
- Pip: Package installer for Python libraries
- Jupyter Notebook: Interactive coding environment

**Online Learning:**
- DataCamp: Python for data analysis courses
- Real Python: Comprehensive Python tutorials
- Python Official Documentation
- Codecademy: Interactive Python course

**Development Tools:**
- VS Code: Free text editor
- PyCharm Community: Free IDE
- Jupyter Notebook: Interactive notebooks
- Google Colab: Free cloud-based notebooks

## Best Practices

1. **Use Meaningful Names:** `customer_count` not `cc`
2. **Comment Your Code:** Explain the "why", not just the "what"
3. **Don't Repeat Code:** Create functions for repeated logic
4. **Handle Errors Gracefully:** Use try/except, don't let crashes happen
5. **Keep Functions Small:** Each function should do one thing
6. **Use List Comprehensions:** More readable than loops
7. **Document Functions:** Add docstrings explaining purpose and arguments
8. **Test Your Code:** Try different inputs, check edge cases
9. **Use Constants:** UPPER_CASE for values that don't change
10. **Version Control:** Use Git for backup and collaboration

## Next Steps

1. **Week 1:** Master Python syntax and data types
2. **Week 2:** Learn functions and file operations
3. **Week 3:** Understand modules and error handling
4. **Week 4:** Build complete analysis scripts
5. **Week 5:** Combine with real datasets and APIs
6. **After:** Move to Pandas for data manipulation
7. **Progression:** Python Basics → Pandas/NumPy → Advanced Analytics
