# Data Analyst Programming Guide

## Pandas Essentials
```python
import pandas as pd
df = pd.read_csv('data.csv')
df.groupby('category')['amount'].agg(['sum', 'mean', 'count'])
df.pivot_table(values='sales', index='region', columns='month')
```

## Data Cleaning
```python
df.dropna()  # Remove missing
df.fillna(df.mean())  # Fill with mean
df.drop_duplicates()  # Remove duplicates
```
