---
name: python-analytics
description: Python data analysis with pandas, numpy, and analytics libraries
version: "2.0.0"
sasmp_version: "2.0.0"
bonded_agent: 05-programming-expert
bond_type: SECONDARY_BOND

# Skill Configuration
config:
  atomic: true
  retry_enabled: true
  max_retries: 3
  backoff_strategy: exponential
  code_execution: sandboxed

# Parameter Validation
parameters:
  skill_level:
    type: string
    required: true
    enum: [beginner, intermediate, advanced]
    default: beginner
  focus_area:
    type: string
    required: false
    enum: [pandas, numpy, visualization, timeseries, all]
    default: all

# Observability
observability:
  logging_level: info
  metrics: [code_efficiency, memory_usage, execution_time]
---

# Python Analytics Skill

## Overview
Master Python for data analysis using industry-standard libraries.

## Topics Covered
- Pandas DataFrames and Series operations
- NumPy array manipulation
- Data aggregation and groupby
- Time series analysis
- Jupyter notebook workflows

## Learning Outcomes
- Analyze data with pandas
- Perform numerical computations
- Build reproducible analysis notebooks
- Process large datasets efficiently

## Error Handling

| Error Type | Cause | Recovery |
|------------|-------|----------|
| MemoryError | Dataset too large | Use chunking or dask |
| KeyError | Column not found | Verify column names |
| ValueError | Invalid operation | Check data types |
| SettingWithCopyWarning | Chained assignment | Use .loc accessor |

## Related Skills
- programming (for Python fundamentals)
- statistics (for statistical analysis)
- advanced (for machine learning)
