---
name: version-control
description: Git version control, branching strategies, GitHub/GitLab workflows, and collaborative development
sasmp_version: "1.3.0"
bonded_agent: 05-cicd-automation
bond_type: PRIMARY_BOND
---

# Version Control Skill

## MANDATORY
- Git fundamentals (init, clone, commit, push, pull)
- Branching strategies (GitFlow, trunk-based, feature branches)
- GitHub/GitLab workflows and collaboration
- Pull/Merge request best practices
- Conflict resolution techniques

## OPTIONAL
- Git hooks and automation
- Signed commits and GPG
- Monorepo vs polyrepo strategies
- Git LFS for large files
- Advanced rebasing and cherry-picking

## ADVANCED
- Custom Git workflows for enterprise
- Migration between VCS platforms
- Git internals and plumbing commands
- Submodules and subtrees
- Git performance optimization

## Assets
- See `assets/git-workflow.yaml` for branching strategy templates
