---
name: uikit-development
description: Master UIKit - Views, controllers, navigation, Auto Layout, animations
sasmp_version: "1.3.0"
version: "2.0.0"
bonded_agent: 02-uikit-development
bond_type: PRIMARY_BOND
last_updated: "2024-12"
---

# UIKit Development Skill

> Build professional iOS interfaces with UIKit

## Learning Objectives

By completing this skill, you will:
- Build complex view hierarchies programmatically
- Master Auto Layout with NSLayoutConstraint
- Implement modern collection views with diffable data sources
- Create smooth animations and transitions
- Ensure accessibility compliance

## Prerequisites

| Requirement | Level |
|-------------|-------|
| iOS Fundamentals | Completed |
| Swift | Intermediate |

## Curriculum

### Module 1: View Hierarchy (4 hours)

**Topics:**
- UIView fundamentals
- UIStackView layouts
- Custom view creation
- Layer properties

### Module 2: View Controllers (5 hours)

**Topics:**
- UIViewController lifecycle
- Container view controllers
- Child VC management
- Presentation styles

### Module 3: Collection Views (6 hours)

**Topics:**
- UICollectionViewCompositionalLayout
- UICollectionViewDiffableDataSource
- Cell registration (iOS 14+)
- Self-sizing cells

### Module 4: Navigation (4 hours)

**Topics:**
- UINavigationController
- Coordinator pattern
- Custom transitions

### Module 5: Animations (4 hours)

**Topics:**
- UIView.animate
- Spring animations
- Keyframe animations
- View controller transitions

### Module 6: Accessibility (3 hours)

**Topics:**
- VoiceOver support
- Dynamic Type
- Color contrast
- Accessibility labels

## Assessment Criteria

| Criteria | Weight |
|----------|--------|
| Layout implementation | 25% |
| Collection view usage | 25% |
| Navigation patterns | 20% |
| Animation quality | 15% |
| Accessibility | 15% |

## Skill Validation

1. **Custom Components**: Build 5 reusable UI components
2. **Complex List**: Multi-section collection view
3. **Navigation Flow**: Coordinator-based navigation
