---
name: migrations
description: Database schema migrations and version control
sasmp_version: "1.3.0"
bonded_agent: 08-sql-devops
bond_type: PRIMARY_BOND
---

# Database Migrations Skill

## Overview
Manage database schema changes with version control, migration tools, and safe deployment practices.

## Topics Covered

### Migration Tools
- Flyway
- Liquibase
- Alembic (Python)
- Prisma migrations
- TypeORM migrations

### Migration Patterns
- Incremental changes
- Reversible migrations
- Data migrations
- Zero-downtime migrations
- Blue-green deployments

### Version Control
- Migration versioning
- Baseline management
- Migration history
- Conflict resolution
- Team workflows

### Best Practices
- Small, focused changes
- Testing migrations
- Rollback strategies
- Documentation
- CI/CD integration

## Prerequisites
- SQL fundamentals
- Version control basics

## Learning Outcomes
- Create safe migrations
- Use migration tools
- Deploy without downtime
- Manage schema versions
