---
name: security
description: Database security, access control, and data protection
sasmp_version: "1.3.0"
bonded_agent: 08-sql-devops
bond_type: PRIMARY_BOND
---

# Database Security Skill

## Overview
Implement comprehensive database security including access control, encryption, and audit logging.

## Topics Covered

### Access Control
- User management
- Role-based access (RBAC)
- Row-level security
- Column-level permissions
- Privilege management

### SQL Injection Prevention
- Parameterized queries
- Input validation
- ORM security
- Stored procedure security
- Application layer defense

### Encryption
- TDE (Transparent Data Encryption)
- Column-level encryption
- TLS/SSL connections
- Key management
- Encryption at rest

### Auditing
- Audit logging
- Change tracking
- Compliance requirements
- Log analysis
- Forensic investigation

### Compliance
- GDPR requirements
- PCI-DSS compliance
- HIPAA considerations
- Data masking
- Data retention policies

## Prerequisites
- SQL fundamentals
- Security concepts

## Learning Outcomes
- Implement access control
- Prevent SQL injection
- Configure encryption
- Set up audit logging
