---
name: transactions
description: Database transactions, ACID properties, and concurrency control
sasmp_version: "1.3.0"
bonded_agent: 01-sql-fundamentals
bond_type: PRIMARY_BOND
---

# Database Transactions Skill

## Overview
Understand and implement database transactions with ACID properties and proper concurrency control.

## Topics Covered

### ACID Properties
- Atomicity
- Consistency
- Isolation
- Durability
- Trade-offs

### Isolation Levels
- Read uncommitted
- Read committed
- Repeatable read
- Serializable
- Snapshot isolation

### Concurrency
- Locking mechanisms
- Deadlock handling
- Optimistic locking
- MVCC concepts
- Lock monitoring

### Transaction Patterns
- Savepoints
- Nested transactions
- Distributed transactions
- Two-phase commit
- Saga pattern

## Prerequisites
- SQL fundamentals
- Database concepts

## Learning Outcomes
- Implement ACID transactions
- Choose isolation levels
- Handle deadlocks
- Design concurrent systems
