---
name: advanced-types
description: Advanced TypeScript types including generics, conditionals, and mapped types
sasmp_version: "1.3.0"
bonded_agent: 01-typescript-fundamentals
bond_type: PRIMARY_BOND
---

# Advanced TypeScript Types Skill

## Overview
Master advanced TypeScript type features including generics, conditional types, mapped types, and utility types.

## Topics Covered

### Generics
- Generic functions
- Generic interfaces
- Generic classes
- Generic constraints
- Default type parameters

### Conditional Types
- Conditional type syntax
- Inferring within conditionals
- Distributive conditionals
- Type filtering
- Never in conditionals

### Mapped Types
- Basic mapped types
- Key remapping
- Modifiers (+/-)
- Template literal types
- Recursive types

### Utility Types
- Partial, Required, Readonly
- Pick, Omit, Record
- Extract, Exclude
- ReturnType, Parameters
- Awaited, NonNullable

### Advanced Patterns
- Type guards
- Branded types
- Opaque types
- Variadic tuple types
- Type-level programming

## Prerequisites
- TypeScript fundamentals
- Basic generics understanding

## Learning Outcomes
- Create complex generic types
- Use conditional types effectively
- Build custom utility types
- Apply type-level patterns
