---
name: fundamentals
description: TypeScript type system fundamentals and basic typing patterns
sasmp_version: "1.3.0"
bonded_agent: 01-typescript-fundamentals
bond_type: PRIMARY_BOND
---

# TypeScript Fundamentals Skill

## Overview
Master TypeScript's type system fundamentals including basic types, interfaces, and type annotations.

## Topics Covered

### Basic Types
- Primitive types (string, number, boolean)
- Arrays and tuples
- Enums
- Any, unknown, never, void
- Null and undefined handling

### Type Annotations
- Variable annotations
- Function parameters and returns
- Object type annotations
- Type inference
- Type assertions

### Interfaces
- Interface declaration
- Optional properties
- Readonly properties
- Index signatures
- Interface extension

### Type Aliases
- Type alias syntax
- Union types
- Intersection types
- Literal types
- Type narrowing

### Functions
- Function type expressions
- Call signatures
- Overloads
- Generic functions
- Rest parameters

## Prerequisites
- JavaScript fundamentals
- ES6+ features

## Learning Outcomes
- Write type-safe code
- Use interfaces effectively
- Apply type narrowing
- Understand type inference
