---
name: testing
description: TypeScript testing strategies and type-safe test practices
sasmp_version: "1.3.0"
bonded_agent: 08-typescript-tooling-quality
bond_type: PRIMARY_BOND
---

# TypeScript Testing Skill

## Overview
Master TypeScript testing including type-safe test setup, mocking with types, and testing type definitions.

## Topics Covered

### Test Setup
- Jest with ts-jest
- Vitest configuration
- ts-node for tests
- Path alias resolution
- Test coverage with types

### Type-Safe Mocking
- Typed mock functions
- jest.Mocked utility
- vi.fn() typing
- Mock implementations
- Partial mocking

### Type Testing
- tsd for type tests
- expect-type library
- Type assertion tests
- Compile-time testing
- Edge case type testing

### Testing Patterns
- Generic test utilities
- Type-safe fixtures
- Builder patterns for tests
- Custom matchers with types
- Assertion type narrowing

### Integration Testing
- API testing with types
- Database testing
- E2E type safety
- Request/response typing
- Test data factories

## Prerequisites
- TypeScript fundamentals
- JavaScript testing basics

## Learning Outcomes
- Write type-safe tests
- Test type definitions
- Create typed mocks
- Build test utilities
