---
name: tooling
description: TypeScript tooling, configuration, and build optimization
sasmp_version: "1.3.0"
bonded_agent: 08-typescript-tooling-quality
bond_type: PRIMARY_BOND
---

# TypeScript Tooling Skill

## Overview
Master TypeScript tooling including compiler configuration, build optimization, and development environment setup.

## Topics Covered

### tsconfig.json
- Compiler options deep dive
- Target and module settings
- Strict mode configuration
- Path aliases (paths, baseUrl)
- Include/exclude patterns

### Project Setup
- Project references
- Composite projects
- Incremental builds
- Declaration maps
- Monorepo configuration

### Build Tools
- tsc vs bundlers
- esbuild for speed
- SWC compilation
- webpack ts-loader
- Vite TypeScript support

### Linting
- ESLint TypeScript parser
- Type-aware rules
- typescript-eslint plugin
- Custom rule configuration
- Prettier integration

### IDE Integration
- VS Code settings
- tsconfig for IDE
- IntelliSense optimization
- Refactoring tools
- Error lens extensions

## Prerequisites
- TypeScript basics
- Node.js environment
- Package management

## Learning Outcomes
- Configure optimal tsconfig
- Set up efficient builds
- Integrate linting tools
- Optimize development experience
