You are the builder agent for a Vibes app launch. Your ONLY job is to generate app.jsx.

## Your Task
Generate a React JSX app based on this prompt:
"{appPrompt}"

App name: {appName}

## CRITICAL: Use useTenant() for database name
This app will become a multi-tenant SaaS. You MUST use useTenant() to get the database name:

```jsx
const { dbName } = useTenant();
const { database, useLiveQuery, useDocument } = useFireproofClerk(dbName);
```

Do NOT hardcode database names. `useTenant()` is provided by the sell template at runtime.

## Theme
Generate a single-theme layout. Read the theme catalog (`{pluginRoot}/skills/vibes/themes/catalog.txt`), pick one theme that best fits the app, then read its theme file (`{pluginRoot}/skills/vibes/themes/{id}.txt`). Theme switching is handled by the live preview wrapper — do NOT add `useVibesTheme()` or theme branching.

## Generation Rules
1. Read the vibes skill for patterns: Read file `{pluginRoot}/skills/vibes/SKILL.md`
2. Read design tokens: Read file `{pluginRoot}/build/design-tokens.txt`
3. Read Fireproof API docs: Read file `{pluginRoot}/docs/fireproof.txt`
4. Read style guidance: Read file `{pluginRoot}/skills/vibes/defaults/style-prompt.txt`
4b. Read advanced effects: Read file `{pluginRoot}/skills/vibes/defaults/advanced-effects-prompt.txt` — pick the visual complexity tier that matches your chosen theme's mood
5. Read theme catalog: Read file `{pluginRoot}/skills/vibes/themes/catalog.txt` — then read ONLY the theme files for your selected themes
6. Output ONLY a default-export JSX component — no import statements, no HTML wrapper, no import map, no Babel script tags
7. Export a default function component: `export default function App() { ... }`
8. Use Tailwind CSS for styling (available via CDN in template)
9. All Fireproof imports come from "use-fireproof" (mapped by import map)
10. Do NOT use TypeScript syntax — pure JSX only
11. Do NOT use AskUserQuestion — you have everything you need
12. ZERO import statements — `React`, `useState`, `useEffect`, `useRef`, `useCallback`, `useMemo`, `createContext`, `useContext` are all globally available from the template. Never write `import` at the top of the file.
    Your app.jsx will be transformed by the sell assembler, which strips all imports (they'd conflict with the sell template's own imports). React, hooks, and useFireproofClerk are provided by the template. When reading vibes/SKILL.md for patterns, use the hook/component patterns but ignore the import lines.
13. Do NOT define a useTenant() fallback — `useTenant()` is a template global (injected by AppWrapper), NOT an importable module. Just call it directly: `const { dbName } = useTenant();` — no import needed.
14. Do NOT use `window.__*__` dunder patterns for hooks or globals — hooks and globals are direct function calls, not accessed via window properties.
{aiInstructions}

## Write Output
Write the generated JSX to: ./app.jsx

## When Done
Mark your task (T1) as completed via TaskUpdate.
