---
name: talk-dig
description: Analyze academic talk posters to discover and summarize the speaker's relevant papers. Extracts speaker info and topic from poster images, searches for their papers online, and provides comprehensive summaries.
---

# Talk Dig - Academic Paper Discovery from Posters

## 概述

这是一个学术研究辅助工具，能够从会议/讲座海报中提取讲者和主题信息，自动搜索该讲者相关的论文，并生成结构化的摘要报告。

## 核心功能

- 📸 **海报分析**: 从图片中提取讲者姓名、演讲标题、时间地点等关键信息
- 🔍 **论文搜索**: 基于讲者和主题，智能搜索相关的学术论文
- 📝 **摘要生成**: 为找到的论文生成简洁易懂的中文摘要
- 🎯 **主题关联**: 识别讲者研究方向与本次talk主题的关联性
- 📊 **结构化输出**: 生成清晰的markdown报告，包含论文链接和关键信息

## 何时使用

当您需要以下情况时使用此Skill：

### 学术场景

- **会议准备**: 参加学术会议前了解演讲者的研究背景
- **讲座调研**: 参加校内/部门讲座前深入了解讲者
- **文献发现**: 通过海报发现新的研究者和相关论文
- **研究追踪**: 追踪特定领域的最新研究动态

### 具体任务示例

- "分析这张海报，找出讲者最近的相关论文"
- "从海报中提取讲者信息，搜索他们的研究工作"
- "这个讲座讲者是谁？他们发表了哪些相关论文？"
- "帮我了解一下这个talk的背景和相关研究"

## 使用方法

### 基本使用

```
请使用talk-dig技能分析这张海报: /path/to/poster.jpg
```

### 高级用法

```
使用talk-dig分析海报，并查找讲者最近3年的相关论文
```

## 工作流程

### 第一步: 海报分析

使用视觉分析工具从海报中提取：
- **讲者姓名**: 识别主 speaker 的名字
- **演讲标题**: 提取talk的完整标题
- **时间地点**: 识别讲座的时间和地点信息
- **所属机构**: 识别讲者的所属机构

### 第二步: 论文搜索

基于提取的信息进行网络搜索：
- 使用讲者姓名 + 演讲主题关键词搜索
- 优先查找最近的论文（1-3年内）
- 识别与talk主题最相关的论文
- 收集论文的标题、摘要、链接等信息

### 第三步: 摘要生成

为每篇找到的论文：
- 阅读论文摘要和简介
- 生成中文摘要（200-300字）
- 提取核心贡献和方法
- 标注与talk主题的相关性

### 第四步: 报告生成

生成结构化的markdown报告，包含：
- 讲者信息简介
- Talk主题分析
- 相关论文列表（按相关性排序）
- 每篇论文的详细摘要
- 进一步阅读建议

## 输出格式

### Markdown报告结构

```markdown
# Talk 分析报告

## 讲者信息
- **姓名**: [讲者姓名]
- **机构**: [所属机构]
- **研究方向**: [根据论文推断的研究方向]

## Talk 信息
- **标题**: [演讲标题]
- **时间**: [时间信息]
- **地点**: [地点信息]
- **主题关键词**: [提取的关键词]

## 相关论文

### 1. [论文标题]
**作者**: [作者列表]
**发表年份**: [年份]
**相关性**: ⭐⭐⭐⭐⭐ (5/5)
**链接**: [论文链接]

**摘要**:
[200-300字的中文摘要]

**核心贡献**:
- 贡献1
- 贡献2
- 贡献3

**与Talk的关联**: [说明与本次talk主题的关系]

---

## 总结
[对讲者研究工作的整体评价和对本次talk的期待]
```

## Technical Implementation

See `references/implementation.md` for:
- MCP tool integration details
- Workflow algorithms
- Error handling strategies
- Search strategies and data sources

## Examples

See `examples/real-scenarios.md` for:
- Conference talk preparation
- Academic lecture analysis
- New area exploration
- Multi-speaker session analysis

## 最佳实践

### 使用建议

1. **提前使用**: 在参加talk前1-2天使用，留出阅读时间
2. **质量检查**: 如果提取的信息不准确，可以手动修正
3. **深度阅读**: 对于高度相关的论文，建议阅读全文
4. **问题准备**: 基于论文内容准备提问

### 提高准确性

- 确保海报图片清晰，文字可读
- 如果讲者有重名，提供额外的上下文信息
- 对于跨学科talk，可以指定搜索的具体领域

## 错误处理

### 常见问题

1. **信息提取失败**: 海报模糊或格式特殊 → 提供手动输入信息
2. **找不到论文**: 讲者是新人或领域冷门 → 扩大搜索范围
3. **论文太多**: 搜索结果过多 → 限制时间范围或相关性过滤
4. **无法访问**: 论文在付费墙后 → 寻找open access版本

### 解决方案

- 使用多个搜索引擎交叉验证
- 优先查找arXiv等开放获取平台
- 必要时使用机构访问权限

## 示例场景

### 场景1: 系列讲座

```
使用talk-dig分析下周三的CS讲座海报，帮我了解讲者的背景
```

### 场景2: 会议准备

```
这是我参加的会议session的海报，分析一下这些speaker的研究工作
```

### 场景3: 新领域探索

```
发现了一个有趣的AI讲座海报，帮我深入了解这个topic和相关研究
```

## 伦理和使用准则

### 学术诚信

- 正确引用和标注论文来源
- 尊重讲者的知识产权
- 仅用于学术研究和学习目的

### 数据隐私

- 不收集或存储个人信息
- 所有搜索结果仅用于生成报告
- 遵守相关平台的使用条款

---

**注意**: 此Skill仅用于学术研究目的，请确保遵守相关的学术伦理和使用条款。
