---
name: todo
description: Systematic todo management approach. Analyze task clarity before adding; ask for details when needed to ensure actionability. Uses Obsidian's todo.md with three regions: Important (重要), Todo, Finish (完成). Trigger when user says "添加任务", "新任务", "记录待办", "管理任务" or needs task reasoning, priority judgment, or task breakdown.
---

# Todo - 待办事项管理

## 核心原则

**简单直接，三区管理**
- **重要**: 高优先级的关键任务
- **Todo**: 普通待办任务
- **Finish**: 已完成的任务

## 文件格式

todo.md 使用标准 Markdown checkbox 格式：

```markdown
# Todo

## 重要

- [ ] 高优先级任务1
- [ ] 高优先级任务2

## Todo

- [ ] 普通任务1
- [ ] 普通任务2

## Finish

- [x] 已完成任务1 ✅ 2026-01-19
- [x] 已完成任务2 ✅ 2026-01-18
```

## 工作流程

### 🔍 添加任务前的推理（重要）

在添加任何任务之前，必须执行以下思考：

#### 1. 分析任务清晰度

检查任务描述是否：
- ✅ **具体明确**: 有明确的行动和结果
- ✅ **可执行**: 知道具体要做什么
- ❌ **过于模糊**: 如"写代码"、"做优化"

#### 2. 任务不清晰时的处理

如果任务描述不够具体，**必须询问用户**：

```
任务"XXX"不够具体，请问：
1. 具体要做什么？
2. 预期结果是什么？
3. 有没有特定的约束或要求？
```

**示例**：
- ❌ 用户说"优化代码" → 询问具体要优化什么
- ❌ 用户说"写文档" → 询问是什么文档，给谁看
- ✅ 用户说"实现用户登录API" → 清晰，可直接添加

#### 3. 适度拆分任务

如果任务过于复杂，建议拆分：

**示例**：
```
用户: "部署到生产环境"

AI: 这是一个复杂任务，建议拆分为：
1. 准备部署配置
2. 备份当前数据
3. 执行数据库迁移
4. 部署新版本
5. 验证部署结果

要按这个拆分添加吗？
```

#### 4. 自动判断优先级

根据任务内容自动判断放入哪个区域：

**放入【重要】的情况**：
- 包含"紧急"、"关键"、"重要"、"bug"、"修复"等词
- 阻塞其他任务的核心问题
- 用户明确说是高优先级

**放入【Todo】的情况**：
- 常规开发任务
- 学习类任务
- 不紧急的优化任务

**不确定时询问**：
```
这个任务应该放哪个区域？
1. 重要 - 高优先级
2. Todo - 普通任务
```

### 基本操作

#### 添加任务

```
添加任务: 完成用户登录功能
添加重要任务: 修复支付bug
新任务: 学习Rust异步编程
```

**推理后添加的示例**：
```
用户: "优化性能"

AI: 性能优化是个大任务。具体要优化：
1. 数据库查询？
2. 前端渲染？
3. API响应时间？
4. 还是整体架构？

请明确一下，我会帮你拆分成具体任务。

---

用户: "数据库查询太慢"

AI: 明白了。这个任务放【重要】还是【Todo】？

用户: 重要

AI: 已添加到【重要】：
- [ ] 优化数据库查询性能
```

#### 完成任务

```
完成任务: 完成用户登录功能
done: 修复支付bug
```

完成时自动添加日期戳并移动到 Finish 区：
```markdown
- [x] 完成用户登录功能 ✅ 2026-01-19
```

#### 移动任务

```
移到重要: 优化数据库查询
移到todo: 学习Rust
```

#### 查看任务

```
查看所有任务
查看重要任务
查看未完成任务
```

#### 删除任务

```
删除任务: 过期的任务
```

## 最佳实践

### 任务描述

✅ 好的任务：
- "实现用户登录API（POST /api/login）"
- "修复支付页面在iOS上的崩溃"
- "编写用户模块的单元测试（覆盖率>80%）"

❌ 差的任务：
- "写代码"
- "做优化"
- "处理问题"

### 优先级判断

**重要（重要区）**：
- Bug修复（特别是线上问题）
- 阻塞其他任务的关键点
- 紧急截止日期的任务
- 核心功能实现

**普通（Todo区）**：
- 新功能开发
- 代码重构
- 文档编写
- 学习研究

### 使用场景示例

详见 `examples/` 目录中的完整对话示例：
- `clear-task.md` - 清晰任务直接添加
- `vague-task.md` - 模糊任务询问细节
- `complex-task.md` - 复杂任务建议拆分
- `priority-judgment.md` - 自动判断优先级

## 注意事项

1. **必须推理**: 不要机械地添加任务，先思考任务是否清晰
2. **主动询问**: 不确定就问，不要猜测
3. **保持简单**: 任务描述应该一行能说完
4. **具体可执行**: 每个任务都应该能直接开始做
5. **适度拆分**: 不要拆得太细，也不要太粗
6. **去重检查**: 添加前检查是否已存在相同或相似任务

## 扩展阅读

- **命令参考**: 见 `references/commands.md`
- **技术实现**: 见 `references/implementation.md`
- **工具集成**: 见 `references/integrations.md`

---

**核心理念**: 在添加任务前先思考，确保每个任务都是清晰、具体、可执行的。不要机械执行，要智能推理。
