# 场景4: 自动判断优先级

## 用户输入

```
添加任务: 修复登录页面500错误
```

## AI 推理过程

**分析任务**:
- 任务描述清晰 ✅
- 具体问题：登录页面500错误
- 可执行：修复bug

**判断优先级**:
- 包含关键词："修复"、"错误" → Bug修复
- 登录功能是核心功能
- 500错误影响用户体验
- **判断：高优先级 → 重要区**

## AI 响应

```
已添加到【重要】:
- [ ] 修复登录页面500错误

（检测到是bug修复，自动放入重要区）
```

## 结果

AI根据任务内容自动判断优先级，将紧急bug放入重要区，无需用户手动指定。

---

## 对比示例：普通任务

### 用户输入

```
添加任务: 学习Rust异步编程
```

### AI 推理

**分析**:
- 任务清晰 ✅
- 学习类任务
- 不紧急

**判断**: 普通优先级 → Todo区

### AI 响应

```
已添加到 Todo:
- [ ] 学习Rust异步编程
```

---

## 优先级判断规则

### 自动放入【重要】的情况

- 包含"紧急"、"关键"、"重要"、"bug"、"修复"、"错误"等词
- 阻塞其他任务的核心问题
- 用户明确说是高优先级

### 自动放入【Todo】的情况

- 常规开发任务
- 学习类任务
- 不紧急的优化任务
- 文档编写

### 需要询问的情况

如果优先级不确定，AI会询问：
```
这个任务应该放哪个区域？
1. 重要 - 高优先级
2. Todo - 普通任务
```
