# Todo 技术实现

## 使用的工具

### Obsidian MCP 工具

1. **读取文件**: `obsidian_get_file_contents("todo.md")`
   - 获取完整文件内容
   - 用于解析现有任务

2. **追加内容**: `obsidian_append_content("todo.md", content)`
   - 创建新文件或追加内容
   - 用于写入完整文件内容

3. **修改部分**: `obsidian_patch_content("todo.md", ...)`
   - 修改特定部分（heading、block、frontmatter）
   - 用于精确修改某个区域

## 任务操作流程

### 添加任务

1. **推理阶段**（必须）：
   - 分析任务是否清晰
   - 不清晰则询问细节
   - 过于复杂则建议拆分
   - 判断优先级

2. **确定区域**：
   - 根据推理结果选择 重要 或 Todo
   - 不确定时询问用户

3. **执行添加**：
   - 读取文件内容
   - 在对应区域添加 `- [ ] 任务描述`
   - 保存文件

### 完成任务

1. 查找任务在哪个区域
2. 改为 `- [x] 任务描述 ✅ YYYY-MM-DD`
3. 移动到 Finish 区
4. 保存文件

### 移动任务

1. 查找任务
2. 从原区域删除
3. 添加到目标区域
4. 保持完成状态
5. 保存文件

### 删除任务

1. 查找并确认任务
2. 从对应分区删除
3. 保存文件

## 任务匹配规则

1. **精确匹配优先**: 完全相同的任务文本
2. **包含匹配备选**: 包含关键词的任务
3. **去重检查**: 避免添加重复任务
   - 添加前检查是否已存在相同或相似任务
   - 如果存在，询问用户是否重复

## 日期格式

完成任务时添加日期戳：
- 格式: `✅ YYYY-MM-DD`
- 示例: `- [x] 完成任务 ✅ 2026-01-19`

## 文件操作策略

- **读取**: 获取完整文件内容
- **解析**: 按分区标题提取任务列表
- **判断**: 检查任务状态 `- [ ]` vs `- [x]`
- **重组**: 按新分区重建 Markdown
- **保存**: 追加或修改文件内容
