# Common IANA Timezones

Quick reference for the most commonly used IANA timezone names.

## Major Cities by Region

### North America
- **America/New_York** - New York, Washington DC, Boston
- **America/Los_Angeles** - Los Angeles, San Francisco, Seattle
- **America/Chicago** - Chicago, Houston, Dallas
- **America/Denver** - Denver, Phoenix, Salt Lake City
- **America/Toronto** - Toronto, Ottawa, Montreal
- **America/Vancouver** - Vancouver, Victoria
- **America/Mexico_City** - Mexico City, Guadalajara

### Europe
- **Europe/London** - London, Cardiff, Belfast
- **Europe/Paris** - Paris, Lyon, Marseille
- **Europe/Berlin** - Berlin, Hamburg, Munich
- **Europe/Rome** - Rome, Milan, Naples
- **Europe/Madrid** - Madrid, Barcelona
- **Europe/Amsterdam** - Amsterdam, Rotterdam
- **Europe/Zurich** - Zurich, Geneva
- **Europe/Stockholm** - Stockholm, Gothenburg
- **Europe/Warsaw** - Warsaw, Krakow
- **Europe/Moscow** - Moscow, St. Petersburg

### Asia
- **Asia/Tokyo** - Tokyo, Osaka, Kyoto
- **Asia/Shanghai** - Shanghai, Beijing, Guangzhou
- **Asia/Hong_Kong** - Hong Kong, Macau
- **Asia/Seoul** - Seoul, Busan
- **Asia/Singapore** - Singapore, Kuala Lumpur
- **Asia/Bangkok** - Bangkok, Phuket
- **Asia/Jakarta** - Jakarta, Surabaya
- **Asia/Manila** - Manila, Cebu
- **Asia/Mumbai** - Mumbai, Delhi, Bangalore
- **Asia/Dubai** - Dubai, Abu Dhabi
- **Asia/Kolkata** - Kolkata, Chennai
- **Asia/Karachi** - Karachi, Lahore

### Oceania
- **Australia/Sydney** - Sydney, Melbourne, Canberra
- **Australia/Perth** - Perth, Fremantle
- **Australia/Adelaide** - Adelaide, Darwin
- **Australia/Brisbane** - Brisbane, Gold Coast
- **Pacific/Auckland** - Auckland, Wellington
- **Pacific/Fiji** - Suva, Nadi

### South America
- **America/Sao_Paulo** - São Paulo, Rio de Janeiro
- **America/Buenos_Aires** - Buenos Aires, Cordoba
- **America/Lima** - Lima, Cusco
- **America/Bogota** - Bogota, Medellin
- **America/Santiago** - Santiago, Valparaiso

### Africa
- **Africa/Cairo** - Cairo, Alexandria
- **Africa/Lagos** - Lagos, Abuja
- **Africa/Johannesburg** - Johannesburg, Cape Town
- **Africa/Nairobi** - Nairobi, Mombasa
- **Africa/Casablanca** - Casablanca, Rabat

## Timezone Abbreviations

### North America
- **EST/EDT** - Eastern Standard/Daylight Time (UTC-5/-4)
- **CST/CDT** - Central Standard/Daylight Time (UTC-6/-5)
- **MST/MDT** - Mountain Standard/Daylight Time (UTC-7/-6)
- **PST/PDT** - Pacific Standard/Daylight Time (UTC-8/-7)

### Europe
- **GMT/BST** - Greenwich Mean/British Summer Time (UTC+0/+1)
- **CET/CEST** - Central European Time (UTC+1/+2)
- **EEST** - Eastern European Summer Time (UTC+3)

### Asia
- **JST** - Japan Standard Time (UTC+9)
- **CST** - China Standard Time (UTC+8)
- **KST** - Korea Standard Time (UTC+9)
- **IST** - India Standard Time (UTC+5:30)
- **GST** - Gulf Standard Time (UTC+4)

### Oceania
- **AEST/AEDT** - Australian Eastern Standard/Daylight Time (UTC+10/+11)
- **NZST/NZDT** - New Zealand Standard/Daylight Time (UTC+12/+13)

## Quick Usage Tips

1. **Always use Area/Location format** (e.g., America/New_York, not EST)
2. **Be specific with city names** when multiple cities share names
3. **Use major cities** for better recognition
4. **Consider DST** - some regions observe daylight saving time
5. **Check UTC offsets** for time differences

## Common Mistakes to Avoid

- ❌ Using abbreviations like "EST" or "PST"
- ❌ Using UTC offsets like "GMT+5"
- ❌ Using generic names like "Eastern Time"
- ✅ Using specific IANA names like "America/New_York"
- ✅ Using major city names for clarity
- ✅ Checking timezone validity before use