---
name: discover-build-systems
description: Automatically discover build system skills when working with build systems. Activates for build-systems development tasks.
---

# Build Systems Skills Discovery

Provides automatic access to comprehensive build-systems skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- build systems
- Make
- CMake
- Gradle
- Maven
- Bazel
- compilation
- incremental builds

## Available Skills

### Quick Reference

The Build-Systems category contains 8 skills:

1. **bazel-monorepos**
2. **build-optimization**
3. **build-system-selection**
4. **cmake-patterns**
5. **cross-platform-builds**
6. **gradle-jvm-builds**
7. **make-fundamentals**
8. **maven-configuration**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/build-systems/INDEX.md
```

This loads the full Build-Systems category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/build-systems/bazel-monorepos.md
cat ~/.claude/skills/build-systems/build-optimization.md
cat ~/.claude/skills/build-systems/build-system-selection.md
cat ~/.claude/skills/build-systems/cmake-patterns.md
cat ~/.claude/skills/build-systems/cross-platform-builds.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects build-systems work
2. **Browse skills**: Run `cat ~/.claude/skills/build-systems/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/build-systems/INDEX.md` to see full category details.
