---
name: discover-cicd
description: Automatically discover CI/CD and automation skills when working with GitHub Actions, Jenkins, GitLab CI, pipelines, continuous integration, continuous deployment, or automated testing. Activates for CI/CD development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Cicd Skills Discovery

Provides automatic access to comprehensive cicd skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- CI/CD
- GitHub Actions
- GitLab CI
- automation
- pipelines
- continuous integration
- deployment automation

## Available Skills

### Quick Reference

The Cicd category contains 4 skills:

1. **cd-deployment-patterns**
2. **ci-optimization**
3. **ci-security**
4. **ci-testing-strategy**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/cicd/INDEX.md


This loads the full Cicd category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/cicd/cd-deployment-patterns.md
Read <cc-polymath-root>/skills/cicd/ci-optimization.md
Read <cc-polymath-root>/skills/cicd/ci-security.md
Read <cc-polymath-root>/skills/cicd/ci-testing-strategy.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects cicd work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/cicd/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/cicd/INDEX.md` to see full category details.
