---
name: discover-containers
description: Automatically discover container and Docker skills when working with Docker. Activates for containers development tasks.
---

# Containers Skills Discovery

Provides automatic access to comprehensive containers skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- Docker
- containers
- Kubernetes
- container security
- networking
- registry
- docker-compose

## Available Skills

### Quick Reference

The Containers category contains 5 skills:

1. **container-networking**
2. **container-registry-management**
3. **container-security**
4. **docker-compose-development**
5. **dockerfile-optimization**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/containers/INDEX.md
```

This loads the full Containers category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/containers/container-networking.md
cat ~/.claude/skills/containers/container-registry-management.md
cat ~/.claude/skills/containers/container-security.md
cat ~/.claude/skills/containers/docker-compose-development.md
cat ~/.claude/skills/containers/dockerfile-optimization.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects containers work
2. **Browse skills**: Run `cat ~/.claude/skills/containers/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/containers/INDEX.md` to see full category details.
