---
name: discover-debugging
description: Automatically discover debugging and profiling skills when working with debugging. Activates for debugging development tasks.
---

# Debugging Skills Discovery

Provides automatic access to comprehensive debugging skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- debugging
- GDB
- LLDB
- profiling
- memory leaks
- performance analysis
- troubleshooting
- diagnostics

## Available Skills

### Quick Reference

The Debugging category contains 14 skills:

1. **browser-devtools**
2. **concurrency-debugging**
3. **container-debugging**
4. **core-dump-analysis**
5. **crash-debugging**
6. **distributed-systems-debugging**
7. **gdb-fundamentals**
8. **lldb-macos-debugging**
9. **memory-leak-debugging**
10. **network-debugging**
11. **performance-profiling**
12. **production-debugging**
13. **python-debugging**
14. **remote-debugging**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/debugging/INDEX.md
```

This loads the full Debugging category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/debugging/browser-devtools.md
cat ~/.claude/skills/debugging/concurrency-debugging.md
cat ~/.claude/skills/debugging/container-debugging.md
cat ~/.claude/skills/debugging/core-dump-analysis.md
cat ~/.claude/skills/debugging/crash-debugging.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects debugging work
2. **Browse skills**: Run `cat ~/.claude/skills/debugging/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/debugging/INDEX.md` to see full category details.
