---
name: discover-infrastructure
description: Automatically discover infrastructure and DevOps skills when working with Terraform, IaC, infrastructure as code, cloud platforms, Cloudflare Workers, or cost optimization. Activates for infrastructure development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Infrastructure Skills Discovery

Provides automatic access to comprehensive infrastructure skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- infrastructure
- Terraform
- IaC
- Cloudflare Workers
- security
- cost optimization
- DevOps

## Available Skills

### Quick Reference

The Infrastructure category contains 6 skills:

1. **aws-serverless**
2. **cloudflare-workers**
3. **cost-optimization**
4. **infrastructure-security**
5. **kubernetes-basics**
6. **terraform-patterns**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/infrastructure/INDEX.md


This loads the full Infrastructure category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/infrastructure/aws-serverless.md
Read <cc-polymath-root>/skills/infrastructure/cloudflare-workers.md
Read <cc-polymath-root>/skills/infrastructure/cost-optimization.md
Read <cc-polymath-root>/skills/infrastructure/infrastructure-security.md
Read <cc-polymath-root>/skills/infrastructure/kubernetes-basics.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects infrastructure work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/infrastructure/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/infrastructure/INDEX.md` to see full category details.
