---
name: discover-infrastructure
description: Automatically discover infrastructure and DevOps skills when working with infrastructure. Activates for infrastructure development tasks.
---

# Infrastructure Skills Discovery

Provides automatic access to comprehensive infrastructure skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- infrastructure
- Terraform
- IaC
- Cloudflare Workers
- security
- cost optimization
- DevOps

## Available Skills

### Quick Reference

The Infrastructure category contains 6 skills:

1. **aws-serverless**
2. **cloudflare-workers**
3. **cost-optimization**
4. **infrastructure-security**
5. **kubernetes-basics**
6. **terraform-patterns**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/infrastructure/INDEX.md
```

This loads the full Infrastructure category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/infrastructure/aws-serverless.md
cat ~/.claude/skills/infrastructure/cloudflare-workers.md
cat ~/.claude/skills/infrastructure/cost-optimization.md
cat ~/.claude/skills/infrastructure/infrastructure-security.md
cat ~/.claude/skills/infrastructure/kubernetes-basics.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects infrastructure work
2. **Browse skills**: Run `cat ~/.claude/skills/infrastructure/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/infrastructure/INDEX.md` to see full category details.
