---
name: discover-ir
description: Automatically discover intermediate representation and compiler skills when working with intermediate representation. Activates for ir development tasks.
---

# Ir Skills Discovery

Provides automatic access to comprehensive ir skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- intermediate representation
- IR
- LLVM IR
- compiler optimizations
- code generation
- SSA

## Available Skills

### Quick Reference

The Ir category contains 5 skills:

1. **ir-query-understanding**
2. **ir-ranking-reranking**
3. **ir-recommendation-systems**
4. **ir-search-fundamentals**
5. **ir-vector-search**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/ir/INDEX.md
```

This loads the full Ir category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/ir/ir-query-understanding.md
cat ~/.claude/skills/ir/ir-ranking-reranking.md
cat ~/.claude/skills/ir/ir-recommendation-systems.md
cat ~/.claude/skills/ir/ir-search-fundamentals.md
cat ~/.claude/skills/ir/ir-vector-search.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects ir work
2. **Browse skills**: Run `cat ~/.claude/skills/ir/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/ir/INDEX.md` to see full category details.
