---
name: discover-math
description: Automatically discover mathematics and algorithm skills when working with linear algebra, calculus, optimization, statistics, probability, numerical methods, category theory, or topology. Activates for math development tasks.
license: MIT
metadata:
  author: rand
  version: "4.0"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Math Skills Discovery

Provides automatic access to comprehensive math skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- mathematics
- algorithms
- linear algebra
- calculus
- topology
- category theory
- proofs
- theorems

## Available Skills

### Quick Reference

The Math category contains 11 skills:

1. **abstract-algebra**
2. **category-theory-foundations**
3. **differential-equations**
4. **linear-algebra-computation**
5. **number-theory**
6. **numerical-methods**
7. **optimization-algorithms**
8. **probability-statistics**
9. **set-theory**
10. **topology-algebraic**
11. **topology-point-set**

### Load Full Category Details

For complete descriptions and workflows:

Read ../math/INDEX.md


This loads the full Math category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read ../math/abstract-algebra.md
Read ../math/category-theory-foundations.md
Read ../math/differential-equations.md
Read ../math/linear-algebra-computation.md
Read ../math/number-theory.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects math work
2. **Browse skills**: Run `Read ../math/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read ../math/INDEX.md` to see full category details.
