---
name: discover-ml
description: Automatically discover machine learning and AI skills when working with machine learning. Activates for ml development tasks.
---

# Ml Skills Discovery

Provides automatic access to comprehensive ml skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- machine learning
- ML
- AI
- models
- training
- inference
- PyTorch
- TensorFlow

## Available Skills

### Quick Reference

The Ml category contains 25 skills:

1. **custom-llm-evaluation**
2. **diffusion-finetuning**
3. **diffusion-model-basics**
4. **dspy-assertions**
5. **dspy-evaluation**
6. **dspy-modules**
7. **dspy-optimizers**
8. **dspy-rag**
9. **dspy-setup**
10. **dspy-signatures**
11. **graph-rag**
12. **hierarchical-rag**
13. **hybrid-search-rag**
14. **llm-as-judge**
15. **llm-benchmarks-evaluation**
16. **llm-dataset-preparation**
17. **llm-evaluation-frameworks**
18. **llm-model-routing**
19. **llm-model-selection**
20. **lora-peft-techniques**
21. **multi-model-orchestration**
22. **rag-evaluation-metrics**
23. **rag-reranking-techniques**
24. **stable-diffusion-deployment**
25. **unsloth-finetuning**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/ml/INDEX.md
```

This loads the full Ml category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/ml/custom-llm-evaluation.md
cat ~/.claude/skills/ml/diffusion-finetuning.md
cat ~/.claude/skills/ml/diffusion-model-basics.md
cat ~/.claude/skills/ml/dspy-assertions.md
cat ~/.claude/skills/ml/dspy-evaluation.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects ml work
2. **Browse skills**: Run `cat ~/.claude/skills/ml/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/ml/INDEX.md` to see full category details.
