---
name: discover-mobile
description: Automatically discover mobile development skills when working with iOS. Activates for mobile development tasks.
---

# Mobile Skills Discovery

Provides automatic access to comprehensive mobile skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- iOS
- Swift
- SwiftUI
- mobile
- SwiftData
- concurrency
- networking
- mobile app development

## Available Skills

### Quick Reference

The Mobile category contains 4 skills:

1. **react-native-native-modules**
2. **react-native-navigation**
3. **react-native-performance**
4. **react-native-setup**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/mobile/INDEX.md
```

This loads the full Mobile category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/mobile/react-native-native-modules.md
cat ~/.claude/skills/mobile/react-native-navigation.md
cat ~/.claude/skills/mobile/react-native-performance.md
cat ~/.claude/skills/mobile/react-native-setup.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects mobile work
2. **Browse skills**: Run `cat ~/.claude/skills/mobile/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/mobile/INDEX.md` to see full category details.
