---
name: discover-networking
description: Automatically discover networking and connectivity skills when working with TCP, UDP, DNS, mTLS, NAT traversal, SSH, Mosh, Tailscale, or network resilience. Activates for networking development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Networking Skills Discovery

Provides automatic access to comprehensive networking skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- networking
- SSH
- mTLS
- NAT traversal
- VPN
- Tailscale
- network resilience
- connection reliability

## Available Skills

### Quick Reference

The Networking category contains 5 skills:

1. **mosh-resilient-ssh**
2. **mtls-implementation**
3. **nat-traversal**
4. **network-resilience-patterns**
5. **tailscale-vpn**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/networking/INDEX.md


This loads the full Networking category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/networking/mosh-resilient-ssh.md
Read <cc-polymath-root>/skills/networking/mtls-implementation.md
Read <cc-polymath-root>/skills/networking/nat-traversal.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects networking work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/networking/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/networking/INDEX.md` to see full category details.
