---
name: discover-protocols
description: Automatically discover protocol skills when working with HTTP, TCP, UDP, QUIC, and network protocols
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Protocols Skills Discovery

Provides automatic access to comprehensive network protocol skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- HTTP, HTTP/2, HTTP/3
- TCP, UDP, QUIC
- network protocols
- protocol debugging
- protocol selection
- network communication
- web protocols
- transport layer
- application layer protocols

## Available Skills

### Quick Reference

The Protocols category contains 8 skills:

1. **grpc-implementation** - gRPC services with Protocol Buffers, streaming RPCs
2. **http2-multiplexing** - HTTP/2 binary protocol, multiplexing, server push, HPACK
3. **kafka-streams** - Apache Kafka stream processing and event streaming
4. **mqtt-messaging** - MQTT pub-sub messaging for IoT and real-time applications
5. **amqp-rabbitmq** - RabbitMQ and AMQP message broker implementation
6. **protobuf-schemas** - Protocol Buffers schema design, evolution, code generation
7. **tcp-optimization** - TCP performance optimization and tuning
8. **websocket-protocols** - WebSocket protocol implementation, scaling, production

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/protocols/INDEX.md


This loads the full Protocols category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/protocols/grpc-implementation.md
Read <cc-polymath-root>/skills/protocols/http2-multiplexing.md
Read <cc-polymath-root>/skills/protocols/kafka-streams.md
Read <cc-polymath-root>/skills/protocols/mqtt-messaging.md
Read <cc-polymath-root>/skills/protocols/amqp-rabbitmq.md
Read <cc-polymath-root>/skills/protocols/protobuf-schemas.md
Read <cc-polymath-root>/skills/protocols/tcp-optimization.md
Read <cc-polymath-root>/skills/protocols/websocket-protocols.md


## Common Workflows

### gRPC Microservices
# Schema design → gRPC implementation → Optimization
Read <cc-polymath-root>/skills/protocols/protobuf-schemas.md
Read <cc-polymath-root>/skills/protocols/grpc-implementation.md
Read <cc-polymath-root>/skills/protocols/http2-multiplexing.md
Read <cc-polymath-root>/skills/protocols/tcp-optimization.md


### Event Streaming Pipeline
# Kafka setup → Stream processing → Schema evolution
Read <cc-polymath-root>/skills/protocols/kafka-streams.md
Read <cc-polymath-root>/skills/protocols/protobuf-schemas.md


### Real-time IoT Platform
# MQTT for devices → RabbitMQ for backend → WebSockets for web
Read <cc-polymath-root>/skills/protocols/mqtt-messaging.md
Read <cc-polymath-root>/skills/protocols/amqp-rabbitmq.md
Read <cc-polymath-root>/skills/protocols/websocket-protocols.md


### High-Performance Web Application
# HTTP/2 optimization → WebSocket for real-time → TCP tuning
Read <cc-polymath-root>/skills/protocols/http2-multiplexing.md
Read <cc-polymath-root>/skills/protocols/websocket-protocols.md
Read <cc-polymath-root>/skills/protocols/tcp-optimization.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects protocol work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/protocols/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/protocols/INDEX.md` to see full category details.
