---
name: discover-realtime
description: Automatically discover realtime communication skills when working with WebSocket, Server-Sent Events, SSE, pub/sub, real-time communication, or live updates. Activates for realtime development tasks.
license: MIT
metadata:
  author: rand
  version: "3.1"
compatibility: Designed for Claude Code. Compatible with any agent supporting the Agent Skills format.
---

# Realtime Skills Discovery

Provides automatic access to comprehensive realtime skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- realtime
- WebSockets
- Server-Sent Events
- streaming
- push notifications
- live updates
- pub/sub

## Available Skills

### Quick Reference

The Realtime category contains 4 skills:

1. **pubsub-patterns**
2. **realtime-sync**
3. **server-sent-events**
4. **websocket-implementation**

### Load Full Category Details

For complete descriptions and workflows:

Read <cc-polymath-root>/skills/realtime/INDEX.md


This loads the full Realtime category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

Read <cc-polymath-root>/skills/realtime/pubsub-patterns.md
Read <cc-polymath-root>/skills/realtime/realtime-sync.md
Read <cc-polymath-root>/skills/realtime/server-sent-events.md
Read <cc-polymath-root>/skills/realtime/websocket-implementation.md


## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects realtime work
2. **Browse skills**: Run `Read <cc-polymath-root>/skills/realtime/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills


**Next Steps**: Run `Read <cc-polymath-root>/skills/realtime/INDEX.md` to see full category details.
