---
name: discover-wasm
description: Automatically discover WebAssembly skills when working with WebAssembly. Activates for wasm development tasks.
---

# Wasm Skills Discovery

Provides automatic access to comprehensive wasm skills.

## When This Skill Activates

This skill auto-activates when you're working with:
- WebAssembly
- WASM
- wasm-pack
- Rust to WASM
- browser WASM
- WASI
- portable bytecode

## Available Skills

### Quick Reference

The Wasm category contains 4 skills:

1. **wasm-browser-integration**
2. **wasm-fundamentals**
3. **wasm-rust-toolchain**
4. **wasm-server-side**

### Load Full Category Details

For complete descriptions and workflows:

```bash
cat ~/.claude/skills/wasm/INDEX.md
```

This loads the full Wasm category index with:
- Detailed skill descriptions
- Usage triggers for each skill
- Common workflow combinations
- Cross-references to related skills

### Load Specific Skills

Load individual skills as needed:

```bash
cat ~/.claude/skills/wasm/wasm-browser-integration.md
cat ~/.claude/skills/wasm/wasm-fundamentals.md
cat ~/.claude/skills/wasm/wasm-rust-toolchain.md
cat ~/.claude/skills/wasm/wasm-server-side.md
```

## Progressive Loading

This gateway skill enables progressive loading:
- **Level 1**: Gateway loads automatically (you're here now)
- **Level 2**: Load category INDEX.md for full overview
- **Level 3**: Load specific skills as needed

## Usage Instructions

1. **Auto-activation**: This skill loads automatically when Claude Code detects wasm work
2. **Browse skills**: Run `cat ~/.claude/skills/wasm/INDEX.md` for full category overview
3. **Load specific skills**: Use bash commands above to load individual skills

---

**Next Steps**: Run `cat ~/.claude/skills/wasm/INDEX.md` to see full category details.
